/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.module.shared;

import java.util.List;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;

public class ArrayValueVisitor {
    private final String prefix;
    private final String suffix;
    private final boolean enforceQuotes;

    public ArrayValueVisitor(String prefix, String suffix, boolean enforceQuotes) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.enforceQuotes = enforceQuotes;
    }

    public Element<?> visit(Element<?> element) {
        if (element instanceof Piece) {
            Piece piece = element;
            element = new Piece(this.prefix + CdnUtils.stringify(this.enforceQuotes, piece.getValue()) + this.suffix);
        } else if (element instanceof Entry) {
            Entry entry = (Entry)element;
            element = new Entry(element.getDescription(), this.prefix + entry.getName() + this.suffix, (Piece)entry.getValue());
        } else if (element instanceof Section) {
            Section sectionElement = (Section)element;
            element = new Section(sectionElement.getDescription(), sectionElement.getOperators(), this.prefix + sectionElement.getName() + this.suffix, (List)sectionElement.getValue());
        } else {
            throw new UnsupportedOperationException("Unsupported array component: " + element);
        }
        return element;
    }
}

