/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.module.standard;

import java.util.Arrays;
import java.util.Stack;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;
import net.dzikoysk.cdn.module.CdnModule;
import net.dzikoysk.cdn.module.standard.StandardOperators;
import org.jetbrains.annotations.Nullable;
import panda.std.Blank;
import panda.std.Result;

public class StandardModule
implements CdnModule {
    @Override
    public void renderDescription(StringBuilder output, String indentation, String description) {
        output.append(indentation).append(description).append("\n");
    }

    @Override
    public void renderSectionOpening(StringBuilder output, String indentation, Section section) {
        output.append(indentation).append(section.getName()).append(section.getName().isEmpty() ? "" : " ").append(section.getOperators()[0]).append("\n");
    }

    @Override
    public void renderSectionEnding(StringBuilder output, String indentation, @Nullable Section parent, Section section) {
        output.append(indentation).append(section.getOperators()[1]).append("\n");
    }

    @Override
    public boolean resolveArray(Stack<Section> sections, Piece value) {
        return !sections.isEmpty() && Arrays.equals(sections.peek().getOperators(), StandardOperators.ARRAY_SEPARATOR);
    }

    @Override
    public Result<Blank, Exception> renderEntry(StringBuilder output, String indentation, @Nullable Section parent, Entry element) {
        output.append(indentation).append(element.getRecord()).append("\n");
        return Result.ok();
    }

    @Override
    public Result<Blank, Exception> renderPiece(StringBuilder output, String indentation, @Nullable Section parent, Piece element) {
        output.append(indentation).append(element.getValue()).append("\n");
        return Result.ok();
    }
}

