/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.module.yaml;

import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.module.standard.StandardOperators;
import panda.utilities.StringUtils;

final class YamlLikeConverter {
    private static final String OBJECT_IN_LIST = "- :";
    private final String[] lines;
    private final StringBuilder converted = new StringBuilder();
    private int previousIndentation = 0;

    YamlLikeConverter(String source) {
        this.lines = StringUtils.split((String)source.replace(System.lineSeparator(), "\n"), (String)"\n");
    }

    String convert() {
        for (String line : this.lines) {
            String indentation = line.substring(0, line.lastIndexOf(line.trim()));
            this.close(indentation.length());
            line = line.trim();
            boolean isArray = line.startsWith("-");
            if (isArray && line.endsWith(StandardOperators.OBJECT_SEPARATOR[0])) {
                line = (line = line.substring(1)).startsWith(" ") ? line.substring(1) : line;
                line = "- " + CdnUtils.stringify(line);
            }
            if (line.endsWith(":") && (!isArray || line.equals(OBJECT_IN_LIST))) {
                this.converted.append(indentation).append(line, 0, line.length() - 1).append(" {").append("\n");
            } else {
                this.converted.append(indentation).append(line).append("\n");
            }
            this.previousIndentation = indentation.length();
        }
        this.close(0);
        return this.converted.toString();
    }

    private void close(int toIndentation) {
        while (this.previousIndentation > toIndentation) {
            this.previousIndentation -= 2;
            this.converted.append(StringUtils.buildSpace((int)this.previousIndentation)).append("}").append("\n");
        }
    }
}

