/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.module.yaml;

import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;
import net.dzikoysk.cdn.module.shared.ArrayValueVisitor;
import net.dzikoysk.cdn.module.standard.StandardModule;
import net.dzikoysk.cdn.module.yaml.YamlLikeConverter;
import org.jetbrains.annotations.Nullable;
import panda.std.Blank;
import panda.std.Result;
import panda.utilities.StringUtils;

public final class YamlLikeModule
extends StandardModule {
    private static final Pattern DEFAULT_COMMENT_OPENING = Pattern.compile("//");
    private final boolean enforceQuotes;
    private final ArrayValueVisitor arrayValueVisitor;

    public YamlLikeModule(boolean enforceQuotes) {
        this.enforceQuotes = enforceQuotes;
        this.arrayValueVisitor = new ArrayValueVisitor("- ", "", enforceQuotes);
    }

    @Override
    public String convertToCdn(String source) {
        YamlLikeConverter converter = new YamlLikeConverter(source);
        return converter.convert();
    }

    @Override
    public void renderDescription(StringBuilder output, String indentation, String description) {
        if ((description = StringUtils.trimStart((String)description)).startsWith("//")) {
            description = DEFAULT_COMMENT_OPENING.matcher(description).replaceFirst("#");
        }
        output.append(indentation).append(description).append("\n");
    }

    @Override
    public void renderSectionOpening(StringBuilder output, String indentation, Section section) {
        output.append(indentation).append(section.getName()).append(":").append("\n");
    }

    @Override
    public void renderSectionEnding(StringBuilder output, String indentation, @Nullable Section parent, Section section) {
    }

    @Override
    public Result<Blank, Exception> renderEntry(StringBuilder output, String indentation, @Nullable Section parent, Entry element) {
        output.append(indentation).append(element.getName()).append(": ").append(element.getPieceValue().trim().equals("[]") ? "[]" : CdnUtils.stringify(this.enforceQuotes, element.getPieceValue())).append("\n");
        return Result.ok();
    }

    @Override
    public Element<?> visitArrayValue(Element<?> element) {
        return this.arrayValueVisitor.visit(element);
    }

    @Override
    public Element<?> resolveArrayValue(Element<?> element) {
        if (element instanceof Piece) {
            Piece piece = element;
            element = new Piece(piece.getValue().replaceFirst("-", "").trim());
        } else if (element instanceof Entry) {
            Entry entry = (Entry)element;
            element = new Piece(entry.getRecord().replaceFirst("-", ""));
        } else if (element instanceof Section) {
            Section sectionElement = (Section)element;
            element = new Section(sectionElement.getDescription(), sectionElement.getOperators(), "- " + sectionElement.getName(), (List)sectionElement.getValue());
        } else {
            throw new UnsupportedOperationException("Unsupported list component: " + element);
        }
        return element;
    }

    @Override
    public boolean resolveArray(Stack<Section> sections, Piece piece) {
        return piece.getValue().startsWith("-");
    }
}

