/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.reflect.AnnotatedMember;
import net.dzikoysk.cdn.reflect.FieldMember;
import net.dzikoysk.cdn.reflect.MemberResolver;
import net.dzikoysk.cdn.reflect.MethodMember;
import net.dzikoysk.cdn.reflect.ReflectUtils;
import net.dzikoysk.cdn.reflect.Visibility;
import org.jetbrains.annotations.NotNull;
import panda.std.Option;
import panda.std.stream.PandaStream;
import panda.utilities.StringUtils;

public class DefaultMemberResolver
implements MemberResolver {
    private final Visibility visibilityToMatch;

    public DefaultMemberResolver(Visibility visibilityToMatch) {
        this.visibilityToMatch = visibilityToMatch;
    }

    @Override
    public AnnotatedMember fromField(@NotNull Class<?> type, @NotNull Field field) {
        return new FieldMember(field, this);
    }

    @Override
    public AnnotatedMember fromProperty(@NotNull Class<?> type, @NotNull String propertyName) throws NoSuchMethodException {
        Method getter = type.getMethod("get" + propertyName, new Class[0]);
        Method setter = type.getMethod("set" + propertyName, getter.getReturnType());
        return new MethodMember(setter, getter, this);
    }

    @Override
    public List<AnnotatedMember> getFields(@NotNull Class<?> type) {
        return PandaStream.of(ReflectUtils.getAllFields(type)).map(field -> this.fromField(type, (Field)field)).toList();
    }

    @Override
    public List<AnnotatedMember> getProperties(@NotNull Class<?> type) {
        return PandaStream.of((Object[])type.getMethods()).filterNot(CdnUtils::isIgnored).map(Method::getName).filter(name -> name.startsWith("get")).map(StringUtils::capitalize).map(name -> name.substring(3)).flatMap(name -> Option.attempt(NoSuchMethodException.class, () -> this.fromProperty(type, (String)name))).toList();
    }

    @Override
    public Visibility getVisibilityToMatch() {
        return this.visibilityToMatch;
    }
}

