/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.reflect.AnnotatedMember;
import net.dzikoysk.cdn.reflect.AnnotatedTargetType;
import net.dzikoysk.cdn.reflect.MemberResolver;
import net.dzikoysk.cdn.reflect.TargetType;
import net.dzikoysk.cdn.reflect.Visibility;
import org.jetbrains.annotations.NotNull;
import panda.std.Blank;
import panda.std.Option;
import panda.std.Result;
import panda.std.function.ThrowingFunction;

public class FieldMember
implements AnnotatedMember {
    private final Field field;
    private final MemberResolver resolver;
    private final Visibility visibility;

    public FieldMember(Field field, MemberResolver resolver) {
        this.field = field;
        this.resolver = resolver;
        this.visibility = Visibility.forMember(field);
    }

    @Override
    public boolean isIgnored() {
        return CdnUtils.isIgnored(this.field, this.resolver.getVisibilityToMatch());
    }

    @Override
    public Result<Blank, ReflectiveOperationException> setValue(@NotNull Object instance, @NotNull Object value) {
        return Result.attempt(ReflectiveOperationException.class, () -> (Blank)this.onField(accessibleField -> {
            accessibleField.set(instance, value);
            return Blank.BLANK;
        }));
    }

    @Override
    public Result<Option<Object>, ReflectiveOperationException> getValue(@NotNull Object instance) {
        return Result.attempt(ReflectiveOperationException.class, () -> Option.of(this.onField(accessibleField -> accessibleField.get(instance))));
    }

    private <R> R onField(ThrowingFunction<Field, R, ReflectiveOperationException> action) throws ReflectiveOperationException {
        if (!this.visibility.isAccessible()) {
            this.field.setAccessible(true);
        }
        return (R)action.apply((Object)this.field);
    }

    @Override
    public boolean isAnnotationPresent(@NotNull Class<? extends Annotation> annotation) {
        return this.field.isAnnotationPresent(annotation);
    }

    @Override
    @NotNull
    public <A extends Annotation> List<A> getAnnotationsByType(@NotNull Class<A> annotation) {
        return Arrays.asList(this.field.getAnnotationsByType(annotation));
    }

    @Override
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotation) {
        return this.field.getAnnotation(annotation);
    }

    @Override
    public TargetType getTargetType() {
        return new AnnotatedTargetType(this.field.getAnnotatedType(), this.resolver);
    }

    @Override
    @NotNull
    public AnnotatedType getAnnotatedType() {
        return this.field.getAnnotatedType();
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    @NotNull
    public String getName() {
        return this.field.getName();
    }
}

