/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.reflect.AnnotatedMember;
import net.dzikoysk.cdn.reflect.AnnotatedTargetType;
import net.dzikoysk.cdn.reflect.MemberResolver;
import net.dzikoysk.cdn.reflect.TargetType;
import org.jetbrains.annotations.NotNull;
import panda.std.Blank;
import panda.std.Option;
import panda.std.Result;

public class MethodMember
implements AnnotatedMember {
    private final Method setter;
    private final Method getter;
    private final MemberResolver resolver;

    public MethodMember(Method setter, Method getter, MemberResolver resolver) {
        this.setter = setter;
        this.getter = getter;
        this.resolver = resolver;
    }

    @Override
    public boolean isIgnored() {
        return CdnUtils.isIgnored(this.setter) || CdnUtils.isIgnored(this.getter);
    }

    @Override
    public Result<Blank, ReflectiveOperationException> setValue(@NotNull Object instance, @NotNull Object value) {
        return Result.attempt(ReflectiveOperationException.class, () -> Option.of((Object)this.setter.invoke(instance, value))).mapToBlank();
    }

    @Override
    public Result<Option<Object>, ReflectiveOperationException> getValue(@NotNull Object instance) {
        return Result.attempt(ReflectiveOperationException.class, () -> Option.of((Object)this.getter.invoke(instance, new Object[0])));
    }

    @Override
    public boolean isAnnotationPresent(@NotNull Class<? extends Annotation> annotation) {
        return this.getter.isAnnotationPresent(annotation);
    }

    @Override
    @NotNull
    public <A extends Annotation> List<A> getAnnotationsByType(@NotNull Class<A> annotation) {
        return Arrays.asList(this.getter.getAnnotationsByType(annotation));
    }

    @Override
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotation) {
        return this.getter.getAnnotation(annotation);
    }

    @Override
    public TargetType getTargetType() {
        return new AnnotatedTargetType(this.getAnnotatedType(), this.resolver);
    }

    @Override
    @NotNull
    public AnnotatedType getAnnotatedType() {
        return this.getter.getAnnotatedReturnType();
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.getter.getReturnType();
    }

    @Override
    @NotNull
    public String getName() {
        return CdnUtils.getPropertyNameFromMethod(this.getter.getName());
    }
}

