/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.serdes;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import net.dzikoysk.cdn.CdnException;
import net.dzikoysk.cdn.CdnSettings;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.entity.Contextual;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Section;
import net.dzikoysk.cdn.reflect.AnnotatedMember;
import net.dzikoysk.cdn.reflect.TargetType;
import net.dzikoysk.cdn.serdes.Composer;
import net.dzikoysk.cdn.serdes.DeserializationHandler;
import panda.std.Option;
import panda.std.Pair;
import panda.std.Result;
import panda.utilities.ObjectUtils;

public final class CdnDeserializer<T> {
    private final CdnSettings settings;

    public CdnDeserializer(CdnSettings settings) {
        this.settings = settings;
    }

    public Result<T, ? extends CdnException> deserialize(Section source, Class<T> template) {
        return this.createInstance(template).mapErr(exception -> new CdnException("Failed to create instance of " + template.getName(), (Throwable)exception)).flatMap(instance -> this.deserialize(source, instance));
    }

    public Result<T, ? extends CdnException> deserialize(Section source, T instance) {
        return this.deserializeToSection(source, false, instance).map(result -> {
            if (result instanceof DeserializationHandler) {
                DeserializationHandler handler = (DeserializationHandler)ObjectUtils.cast((Object)result);
                return handler.handle(ObjectUtils.cast((Object)instance));
            }
            return result;
        }).mapErr(CdnException::new);
    }

    private <I> Result<I, ? extends Exception> deserializeToSection(Section source, boolean immutableParent, I instance) {
        Class<?> type = instance.getClass();
        boolean immutable = immutableParent || CdnUtils.isKotlinDataClass(type);
        ArrayList<AnnotatedMember> members = new ArrayList<AnnotatedMember>();
        members.addAll(this.settings.getAnnotationResolver().getFields(type));
        members.addAll(this.settings.getAnnotationResolver().getProperties(type));
        ArrayList<Pair> args = new ArrayList<Pair>();
        for (AnnotatedMember annotatedMember : members) {
            Result<Option<Object>, Exception> result = this.deserializeMember(source, immutable, annotatedMember, instance);
            if (result.isErr()) {
                return result.projectToError();
            }
            Object argumentValue = ((Option)result.get()).orElse(() -> (Option)annotatedMember.getValue(instance).orThrow(RuntimeException::new)).orNull();
            args.add(new Pair(annotatedMember.getType(), argumentValue));
        }
        if (immutable) {
            Class[] argsTypes = (Class[])args.stream().map(Pair::getFirst).toArray(Class[]::new);
            Object[] values = args.stream().map(Pair::getSecond).toArray();
            return this.createInstance(instance.getClass(), argsTypes, values).projectToError();
        }
        return Result.ok(instance);
    }

    private Result<Option<Object>, ? extends Exception> deserializeMember(Section source, boolean immutable, AnnotatedMember member, Object instance) {
        if (member.isIgnored()) {
            return Result.ok((Object)Option.none());
        }
        Option<Element<?>> elementValue = source.get(member.getName());
        if (elementValue.isEmpty()) {
            return Result.ok((Object)Option.none());
        }
        Element element = (Element)elementValue.get();
        Result<Option<Object>, ReflectiveOperationException> defaultValueResult = member.getValue(instance);
        if (defaultValueResult.isErr()) {
            return defaultValueResult.projectToError();
        }
        Option optionDefaultValue = (Option)defaultValueResult.get();
        if (member.isAnnotationPresent(Contextual.class)) {
            Object defaultValue;
            Section section = (Section)element;
            if (optionDefaultValue.isEmpty()) {
                Result<?, ReflectiveOperationException> sectionInstance = this.createInstance(member.getType());
                if (sectionInstance.isErr()) {
                    return sectionInstance.projectToError();
                }
                defaultValue = sectionInstance.get();
            } else {
                defaultValue = optionDefaultValue.get();
            }
            return this.deserializeToSection(section, immutable, defaultValue).map(Option::of);
        }
        TargetType targetType = member.getTargetType();
        return CdnUtils.findComposer(this.settings, targetType, member).flatMap(deserializer -> deserializer.deserialize(this.settings, element, targetType, optionDefaultValue.orNull(), false)).peek(value -> {
            if (!immutable && value != Composer.MEMBER_ALREADY_PROCESSED) {
                member.setValue(instance, value).orThrow(IllegalStateException::new);
            }
        }).map(Option::of);
    }

    private <TYPE> Result<TYPE, ReflectiveOperationException> createInstance(Class<TYPE> type) {
        return this.createInstance(type, new Class[0], new Object[0]);
    }

    private <TYPE> Result<TYPE, ReflectiveOperationException> createInstance(Class<TYPE> type, Class<?>[] argsTypes, Object[] args) {
        return Result.attempt(ReflectiveOperationException.class, () -> {
            if (!this.settings.getAnnotationResolver().getVisibilityToMatch().isAccessible()) {
                Constructor constructor = type.getDeclaredConstructor(argsTypes);
                constructor.setAccessible(true);
                return constructor.newInstance(args);
            }
            return type.getConstructor(argsTypes).newInstance(args);
        });
    }
}

