/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.serdes;

import net.dzikoysk.cdn.CdnSettings;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.reflect.TargetType;
import net.dzikoysk.cdn.serdes.Deserializer;
import panda.std.Result;

@FunctionalInterface
public interface SimpleDeserializer<T>
extends Deserializer<T> {
    @Override
    default public Result<T, Exception> deserialize(CdnSettings settings, Element<?> source, TargetType type, T defaultValue, boolean entryAsRecord) {
        if (source instanceof Piece) {
            return this.deserialize(type, CdnUtils.destringify(((Piece)source).getValue()));
        }
        if (source instanceof Entry) {
            Entry entry = (Entry)source;
            return this.deserialize(type, CdnUtils.destringify(entryAsRecord ? entry.getRaw() : entry.getPieceValue()));
        }
        return Result.error((Object)new UnsupportedOperationException(String.format("Simple deserializer can deserialize only units (%s from %s)", type, source.getClass())));
    }

    default public Result<T, Exception> deserialize(TargetType type, String source) {
        return this.deserialize(source);
    }

    public Result<T, Exception> deserialize(String var1);
}

