/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.serdes.composers;

import java.util.List;
import net.dzikoysk.cdn.CdnException;
import net.dzikoysk.cdn.CdnSettings;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.reflect.TargetType;
import net.dzikoysk.cdn.serdes.Composer;
import panda.std.Result;
import panda.std.reactive.Reference;
import panda.std.reactive.ReferenceUtils;

public final class ReferenceComposer<T>
implements Composer<T> {
    @Override
    public Result<T, Exception> deserialize(CdnSettings settings, Element<?> source, TargetType type, T defaultValue, boolean entryAsRecord) {
        if (defaultValue == null) {
            return Result.error((Object)new CdnException("Default value of reference cannot be null!"));
        }
        Reference defaultReference = (Reference)defaultValue;
        TargetType referenceType = type.getAnnotatedActualTypeArguments()[0];
        return CdnUtils.findComposer(settings, referenceType, null).flatMap(deserializer -> deserializer.deserialize(settings, source, referenceType, defaultReference.get(), entryAsRecord)).map(value -> {
            Reference reference = (Reference)defaultValue;
            ReferenceUtils.setValue((Reference)reference, (Object)value);
            return MEMBER_ALREADY_PROCESSED;
        });
    }

    @Override
    public Result<? extends Element<?>, Exception> serialize(CdnSettings settings, List<String> description, String key, TargetType type, T entity) {
        Reference reference = (Reference)entity;
        TargetType[] referenceTypes = type.getAnnotatedActualTypeArguments();
        TargetType referenceType = referenceTypes[0];
        return CdnUtils.findComposer(settings, referenceType, null).flatMap(serializer -> serializer.serialize(settings, description, key, referenceType, reference.get()));
    }
}

