/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.source;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.dzikoysk.cdn.source.Source;
import panda.utilities.IOUtils;

final class InputStreamSource
implements Source {
    private final InputStream inputStream;
    private final Charset encoding;

    InputStreamSource(InputStream inputStream, Charset encoding) {
        if (inputStream == null) {
            throw new IllegalStateException("InputStream cannot be null");
        }
        if (encoding == null) {
            throw new IllegalStateException("Encoding cannot be null");
        }
        this.inputStream = inputStream;
        this.encoding = encoding;
    }

    @Override
    public String getSource() {
        try {
            String string = (String)IOUtils.convertStreamToString((InputStream)this.inputStream, (Charset)this.encoding).orElseThrow(failure -> {
                throw new IllegalStateException("Cannot read input stream", (Throwable)failure);
            });
            return string;
        }
        finally {
            IOUtils.close((Closeable)this.inputStream);
        }
    }
}

