/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.e175.klaus.solarpositioning.AzimuthZenithAngle;

public final class PSA {
    private static final double D_EARTH_MEAN_RADIUS = 6371.01;
    private static final double D_ASTRONOMICAL_UNIT = 1.4959789E8;
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;
    private static final double RAD = Math.PI / 180;

    private PSA() {
    }

    public static AzimuthZenithAngle calculateSolarPosition(GregorianCalendar date, double latitude, double longitude) {
        GregorianCalendar utcTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        utcTime.setTimeInMillis(date.getTimeInMillis());
        double dDecimalHours = (double)utcTime.get(11) + ((double)utcTime.get(12) + (double)utcTime.get(13) / 60.0) / 60.0;
        long liAux1 = (utcTime.get(2) + 1 - 14) / 12;
        long liAux2 = 1461L * ((long)(utcTime.get(1) + 4800) + liAux1) / 4L + 367L * ((long)(utcTime.get(2) + 1 - 2) - 12L * liAux1) / 12L - 3L * (((long)(utcTime.get(1) + 4900) + liAux1) / 100L) / 4L + (long)utcTime.get(5) - 32075L;
        double dJulianDate = (double)liAux2 - 0.5 + dDecimalHours / 24.0;
        double dElapsedJulianDays = dJulianDate - 2451545.0;
        double dOmega = 2.1429 - 0.0010394594 * dElapsedJulianDays;
        double dMeanLongitude = 4.895063 + 0.017202791698 * dElapsedJulianDays;
        double dMeanAnomaly = 6.24006 + 0.0172019699 * dElapsedJulianDays;
        double dEclipticLongitude = dMeanLongitude + 0.03341607 * Math.sin(dMeanAnomaly) + 3.4894E-4 * Math.sin(2.0 * dMeanAnomaly) - 1.134E-4 - 2.03E-5 * Math.sin(dOmega);
        double dEclipticObliquity = 0.4090928 - 6.214E-9 * dElapsedJulianDays + 3.96E-5 * Math.cos(dOmega);
        double dSinEclipticLongitude = Math.sin(dEclipticLongitude);
        double dY = Math.cos(dEclipticObliquity) * dSinEclipticLongitude;
        double dX = Math.cos(dEclipticLongitude);
        double dRightAscension = Math.atan2(dY, dX);
        if (dRightAscension < 0.0) {
            dRightAscension += Math.PI * 2;
        }
        double dDeclination = Math.asin(Math.sin(dEclipticObliquity) * dSinEclipticLongitude);
        double dGreenwichMeanSiderealTime = 6.6974243242 + 0.0657098283 * dElapsedJulianDays + dDecimalHours;
        double dLocalMeanSiderealTime = (dGreenwichMeanSiderealTime * 15.0 + longitude) * (Math.PI / 180);
        double dHourAngle = dLocalMeanSiderealTime - dRightAscension;
        double dLatitudeInRadians = latitude * (Math.PI / 180);
        double dCosLatitude = Math.cos(dLatitudeInRadians);
        double dSinLatitude = Math.sin(dLatitudeInRadians);
        double dCosHourAngle = Math.cos(dHourAngle);
        double zenithAngle = Math.acos(dCosLatitude * dCosHourAngle * Math.cos(dDeclination) + Math.sin(dDeclination) * dSinLatitude);
        dY = -Math.sin(dHourAngle);
        double azimuth = Math.atan2(dY, dX = Math.tan(dDeclination) * dCosLatitude - dSinLatitude * dCosHourAngle);
        if (azimuth < 0.0) {
            azimuth += Math.PI * 2;
        }
        double dParallax = 4.2587565907513806E-5 * Math.sin(zenithAngle);
        zenithAngle = (zenithAngle + dParallax) / (Math.PI / 180);
        return new AzimuthZenithAngle(azimuth /= Math.PI / 180, zenithAngle);
    }
}

