/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.util.GregorianCalendar;

public final class DeltaT {
    private DeltaT() {
    }

    public static double estimate(GregorianCalendar forDate) {
        double deltaT;
        double year = DeltaT.decimalYear(forDate);
        if (year < -500.0) {
            double u = (year - 1820.0) / 100.0;
            deltaT = -20.0 + 32.0 * Math.pow(u, 2.0);
        } else if (year < 500.0) {
            double u = year / 100.0;
            deltaT = 10583.6 - 1014.41 * u + 33.78311 * Math.pow(u, 2.0) - 5.952053 * Math.pow(u, 3.0) - 0.1798452 * Math.pow(u, 4.0) + 0.022174192 * Math.pow(u, 5.0) + 0.0090316521 * Math.pow(u, 6.0);
        } else if (year < 1600.0) {
            double u = (year - 1000.0) / 100.0;
            deltaT = 1574.2 - 556.01 * u + 71.23472 * Math.pow(u, 2.0) + 0.319781 * Math.pow(u, 3.0) - 0.8503463 * Math.pow(u, 4.0) - 0.005050998 * Math.pow(u, 5.0) + 0.0083572073 * Math.pow(u, 6.0);
        } else if (year < 1700.0) {
            double t = year - 1600.0;
            deltaT = 120.0 - 0.9808 * t - 0.01532 * Math.pow(t, 2.0) + Math.pow(t, 3.0) / 7129.0;
        } else if (year < 1800.0) {
            double t = year - 1700.0;
            deltaT = 8.83 + 0.1603 * t - 0.0059285 * Math.pow(t, 2.0) + 1.3336E-4 * Math.pow(t, 3.0) - Math.pow(t, 4.0) / 1174000.0;
        } else if (year < 1860.0) {
            double t = year - 1800.0;
            deltaT = 13.72 - 0.332447 * t + 0.0068612 * Math.pow(t, 2.0) + 0.0041116 * Math.pow(t, 3.0) - 3.7436E-4 * Math.pow(t, 4.0) + 1.21272E-5 * Math.pow(t, 5.0) - 1.699E-7 * Math.pow(t, 6.0) + 8.75E-10 * Math.pow(t, 7.0);
        } else if (year < 1900.0) {
            double t = year - 1860.0;
            deltaT = 7.62 + 0.5737 * t - 0.251754 * Math.pow(t, 2.0) + 0.01680668 * Math.pow(t, 3.0) - 4.473624E-4 * Math.pow(t, 4.0) + Math.pow(t, 5.0) / 233174.0;
        } else if (year < 1920.0) {
            double t = year - 1900.0;
            deltaT = -2.79 + 1.494119 * t - 0.0598939 * Math.pow(t, 2.0) + 0.0061966 * Math.pow(t, 3.0) - 1.97E-4 * Math.pow(t, 4.0);
        } else if (year < 1941.0) {
            double t = year - 1920.0;
            deltaT = 21.2 + 0.84493 * t - 0.0761 * Math.pow(t, 2.0) + 0.0020936 * Math.pow(t, 3.0);
        } else if (year < 1961.0) {
            double t = year - 1950.0;
            deltaT = 29.07 + 0.407 * t - Math.pow(t, 2.0) / 233.0 + Math.pow(t, 3.0) / 2547.0;
        } else if (year < 1986.0) {
            double t = year - 1975.0;
            deltaT = 45.45 + 1.067 * t - Math.pow(t, 2.0) / 260.0 - Math.pow(t, 3.0) / 718.0;
        } else if (year < 2005.0) {
            double t = year - 2000.0;
            deltaT = 63.86 + 0.3345 * t - 0.060374 * Math.pow(t, 2.0) + 0.0017275 * Math.pow(t, 3.0) + 6.51814E-4 * Math.pow(t, 4.0) + 2.373599E-5 * Math.pow(t, 5.0);
        } else if (year < 2050.0) {
            double t = year - 2000.0;
            deltaT = 62.92 + 0.32217 * t + 0.005589 * Math.pow(t, 2.0);
        } else if (year < 2150.0) {
            deltaT = -20.0 + 32.0 * Math.pow((year - 1820.0) / 100.0, 2.0) - 0.5628 * (2150.0 - year);
        } else {
            double u = (year - 1820.0) / 100.0;
            deltaT = -20.0 + 32.0 * Math.pow(u, 2.0);
        }
        return deltaT;
    }

    private static double decimalYear(GregorianCalendar forDate) {
        double rawYear = forDate.get(1);
        if (forDate.get(0) == 0) {
            rawYear = -rawYear;
        }
        return rawYear + ((double)(forDate.get(2) + 1) - 0.5) / 12.0;
    }
}

