/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class JulianDate {
    private final double julianDate;
    private final double deltaT;

    public JulianDate(ZonedDateTime date) {
        this(date, 0.0);
    }

    public JulianDate(double fromJulianDate, double deltaT) {
        this.julianDate = fromJulianDate;
        this.deltaT = deltaT;
    }

    public JulianDate(ZonedDateTime date, double deltaT) {
        ZonedDateTime zonedDateTime = JulianDate.createUtcDateTime(date).withZoneSameInstant(ZoneOffset.UTC);
        this.julianDate = this.calcJulianDate(zonedDateTime.toLocalDateTime());
        this.deltaT = deltaT;
    }

    static ZonedDateTime createUtcDateTime(ZonedDateTime fromDateTime) {
        return fromDateTime.withZoneSameInstant(ZoneOffset.UTC);
    }

    private double calcJulianDate(LocalDateTime localDateTime) {
        int y = localDateTime.getYear();
        int m = localDateTime.getMonthValue();
        if (m < 3) {
            --y;
            m += 12;
        }
        double d = (double)localDateTime.getDayOfMonth() + ((double)localDateTime.getHour() + ((double)localDateTime.getMinute() + (double)localDateTime.getSecond() / 60.0) / 60.0) / 24.0;
        double jd = Math.floor(365.25 * ((double)y + 4716.0)) + Math.floor(30.6001 * (double)(m + 1)) + d - 1524.5;
        double a = Math.floor((double)y / 100.0);
        double b = jd > 2299160.0 ? 2.0 - a + Math.floor(a / 4.0) : 0.0;
        return jd + b;
    }

    public double getJulianDate() {
        return this.julianDate;
    }

    public double getJulianEphemerisDay() {
        return this.julianDate + this.deltaT / 86400.0;
    }

    public double getJulianCentury() {
        return (this.julianDate - 2451545.0) / 36525.0;
    }

    public double getJulianEphemerisCentury() {
        return (this.getJulianEphemerisDay() - 2451545.0) / 36525.0;
    }

    public double getJulianEphemerisMillennium() {
        return this.getJulianEphemerisCentury() / 10.0;
    }

    public String toString() {
        return String.format("%.5f", this.julianDate);
    }
}

