/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.time.LocalDate;
import net.e175.klaus.solarpositioning.MathUtil;

public final class DeltaT {
    private DeltaT() {
    }

    public static double estimate(LocalDate forDate) {
        double year = DeltaT.decimalYear(forDate);
        return DeltaT.estimate(year);
    }

    public static double estimate(double year) {
        double deltaT;
        if (year < -500.0) {
            double u = (year - 1820.0) / 100.0;
            deltaT = MathUtil.polynomial(u, -20.0, 0.0, 32.0);
        } else if (year < 500.0) {
            double u = year / 100.0;
            deltaT = MathUtil.polynomial(u, 10583.6, -1014.41, 33.78311, -5.952053, -0.1798452, 0.022174192, 0.0090316521);
        } else if (year < 1600.0) {
            double u = (year - 1000.0) / 100.0;
            deltaT = MathUtil.polynomial(u, 1574.2, -556.01, 71.23472, 0.319781, -0.8503463, -0.005050998, 0.0083572073);
        } else if (year < 1700.0) {
            double t = year - 1600.0;
            deltaT = MathUtil.polynomial(t, 120.0, -0.9808, -0.01532, 1.4027212792818068E-4);
        } else if (year < 1800.0) {
            double t = year - 1700.0;
            deltaT = MathUtil.polynomial(t, 8.83, 0.1603, -0.0059285, 1.3336E-4, -8.517887563884157E-7);
        } else if (year < 1860.0) {
            double t = year - 1800.0;
            deltaT = MathUtil.polynomial(t, 13.72, -0.332447, 0.0068612, 0.0041116, -3.7436E-4, 1.21272E-5, -1.699E-7, 8.75E-10);
        } else if (year < 1900.0) {
            double t = year - 1860.0;
            deltaT = MathUtil.polynomial(t, 7.62, 0.5737, -0.251754, 0.01680668, -4.473624E-4, 4.288642816094419E-6);
        } else if (year < 1920.0) {
            double t = year - 1900.0;
            deltaT = MathUtil.polynomial(t, -2.79, 1.494119, -0.0598939, 0.0061966, -1.97E-4);
        } else if (year < 1941.0) {
            double t = year - 1920.0;
            deltaT = MathUtil.polynomial(t, 21.2, 0.84493, -0.0761, 0.0020936);
        } else if (year < 1961.0) {
            double t = year - 1950.0;
            deltaT = MathUtil.polynomial(t, 29.07, 0.407, -0.004291845493562232, 3.9261876717707107E-4);
        } else if (year < 1986.0) {
            double t = year - 1975.0;
            deltaT = MathUtil.polynomial(t, 45.45, 1.067, -0.0038461538461538464, -0.001392757660167131);
        } else if (year < 2005.0) {
            double t = year - 2000.0;
            deltaT = MathUtil.polynomial(t, 63.86, 0.3345, -0.060374, 0.0017275, 6.51814E-4, 2.373599E-5);
        } else if (year < 2015.0) {
            double t = year - 2005.0;
            deltaT = MathUtil.polynomial(t, 64.69, 0.293);
        } else if (year <= 3000.0) {
            double t = year - 2015.0;
            deltaT = MathUtil.polynomial(t, 67.62, 0.3645, 0.0039755);
        } else {
            throw new IllegalArgumentException("no estimates possible for this time");
        }
        return deltaT;
    }

    private static double decimalYear(LocalDate forDate) {
        return (double)forDate.getYear() + ((double)forDate.getMonthValue() - 0.5) / 12.0;
    }
}

