/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.solarpositioning;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.e175.klaus.solarpositioning.MathUtil;
import net.e175.klaus.solarpositioning.SolarPosition;

public final class Grena3 {
    private Grena3() {
    }

    public static SolarPosition calculateSolarPosition(ZonedDateTime date, double latitude, double longitude, double deltaT) {
        return Grena3.calculateSolarPosition(date, latitude, longitude, deltaT, Double.NaN, Double.NaN);
    }

    public static SolarPosition calculateSolarPosition(ZonedDateTime date, double latitude, double longitude, double deltaT, double pressure, double temperature) {
        MathUtil.checkLatLonRange(latitude, longitude);
        double t = Grena3.calcT(date);
        double tE = t + 1.1574E-5 * deltaT;
        double omegaAtE = 0.0172019715 * tE;
        double lambda = -1.388803 + 0.01720279216 * tE + 0.033366 * Math.sin(omegaAtE - 0.06172) + 3.53E-4 * Math.sin(2.0 * omegaAtE - 0.1163);
        double epsilon = 0.4089567 - 6.19E-9 * tE;
        double sLambda = Math.sin(lambda);
        double cLambda = Math.cos(lambda);
        double sEpsilon = Math.sin(epsilon);
        double cEpsilon = Math.sqrt(1.0 - sEpsilon * sEpsilon);
        double alpha = Math.atan2(sLambda * cEpsilon, cLambda);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        double delta = Math.asin(sLambda * sEpsilon);
        double H = 1.7528311 + 6.300388099 * t + Math.toRadians(longitude) - alpha;
        if ((H = (H + Math.PI) % (Math.PI * 2) - Math.PI) < -Math.PI) {
            H += Math.PI * 2;
        }
        double sPhi = Math.sin(Math.toRadians(latitude));
        double cPhi = Math.sqrt(1.0 - sPhi * sPhi);
        double sDelta = Math.sin(delta);
        double cDelta = Math.sqrt(1.0 - sDelta * sDelta);
        double sH = Math.sin(H);
        double cH = Math.cos(H);
        double sEpsilon0 = sPhi * sDelta + cPhi * cDelta * cH;
        double eP = Math.asin(sEpsilon0) - 4.26E-5 * Math.sqrt(1.0 - sEpsilon0 * sEpsilon0);
        double gamma = Math.atan2(sH, cH * sPhi - sDelta * cPhi / cDelta);
        boolean doCorrect = Double.isFinite(pressure) && Double.isFinite(temperature) && pressure > 0.0 && pressure < 3000.0 && temperature > -273.0 && temperature < 273.0 && eP > 0.0;
        double deltaRe = doCorrect ? 0.08422 * (pressure / 1000.0) / ((273.0 + temperature) * Math.tan(eP + 0.003138 / (eP + 0.08919))) : 0.0;
        double z = 1.5707963267948966 - eP - deltaRe;
        return new SolarPosition(Math.toDegrees(gamma + Math.PI) % 360.0, Math.toDegrees(z));
    }

    private static double calcT(ZonedDateTime date) {
        ZonedDateTime utc = date.withZoneSameInstant(ZoneOffset.UTC);
        int m = utc.getMonthValue();
        int y = utc.getYear();
        int d = utc.getDayOfMonth();
        double h = (double)utc.getHour() + (double)utc.getMinute() / 60.0 + (double)utc.getSecond() / 3600.0;
        if (m <= 2) {
            m += 12;
            --y;
        }
        return (double)((int)(365.25 * (double)(y - 2000)) + (int)(30.6001 * (double)(m + 1)) - (int)(0.01 * (double)y) + d) + 0.0416667 * h - 21958.0;
    }
}

