/*
 * Decompiled with CFR 0.152.
 */
package net.e175.klaus.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;

final class BinaryMapper {
    private static final Logger LOG = Logger.getLogger(BinaryMapper.class.getName());

    private BinaryMapper() {
    }

    static Optional<PatternInstance> seek(PatternSpec spec, SeekableByteChannel inChannel, long startPosition, boolean forward) throws IOException {
        return BinaryMapper.seek(spec, inChannel, startPosition, -1L, forward);
    }

    static Optional<PatternInstance> seek(PatternSpec spec, SeekableByteChannel inChannel, long startPosition, long maxDistance, boolean forward) throws IOException {
        BooleanSupplier mayProceed;
        long maxPosition = inChannel.size() - (long)spec.size;
        if (maxDistance > 0L) {
            AtomicLong stepCounter = new AtomicLong();
            mayProceed = () -> stepCounter.incrementAndGet() <= maxDistance;
        } else {
            mayProceed = () -> true;
        }
        long step = forward ? 1L : -1L;
        return BinaryMapper.seek(spec, inChannel, forward ? Math.max(0L, startPosition) : Math.min(maxPosition, startPosition), pi -> mayProceed.getAsBoolean() ? step : 0L, 0L, maxPosition);
    }

    static Optional<PatternInstance> seek(PatternSpec spec, SeekableByteChannel inChannel, long startPosition, Function<PatternInstance, Long> stepSupplier, long minPosition, long maxPosition) throws IOException {
        long stepSupplied;
        ByteBuffer buf = spec.bufferFor();
        long realMaxPosition = Math.min(maxPosition, inChannel.size() - (long)spec.size);
        long realMinPosition = Math.max(0L, minPosition);
        for (long i = startPosition; i <= realMaxPosition && i >= realMinPosition; i += stepSupplied) {
            PatternInstance readInstance = BinaryMapper.readUnvalidated(spec, inChannel, i, buf);
            if (readInstance.validateMagic()) {
                return Optional.of(readInstance);
            }
            stepSupplied = stepSupplier.apply(readInstance);
            if (stepSupplied == 0L) break;
        }
        return Optional.empty();
    }

    static Optional<PatternInstance> read(PatternSpec spec, SeekableByteChannel inChannel, long position, ByteBuffer buf) throws IOException {
        PatternInstance pi = BinaryMapper.readUnvalidated(spec, inChannel, position, buf);
        if (pi.validateMagic()) {
            return Optional.of(pi);
        }
        return Optional.empty();
    }

    static PatternInstance readUnvalidated(PatternSpec spec, SeekableByteChannel inChannel, long position, ByteBuffer buf) throws IOException {
        inChannel.position(position);
        int bytesRead = inChannel.read(buf);
        assert (bytesRead == spec.size);
        PatternInstance pi = new PatternInstance(spec, position, buf);
        buf.rewind();
        return pi;
    }

    static Optional<PatternInstance> read(PatternSpec spec, SeekableByteChannel inChannel, long i) throws IOException {
        ByteBuffer buf = spec.bufferFor();
        return BinaryMapper.read(spec, inChannel, i, buf);
    }

    static Queue<Write> createWriteQueue() {
        return new PriorityQueue<Write>(11, Comparator.comparingLong(w -> w.position));
    }

    static void applyWrites(Queue<Write> writes, SeekableByteChannel toChannel) throws IOException {
        LOG.fine(() -> "writing " + writes.size() + " Writes");
        while (!writes.isEmpty()) {
            Write w = writes.poll();
            toChannel.position(w.position);
            toChannel.write(w.data);
            LOG.fine(() -> "wrote " + w);
        }
    }

    static final class PatternSpec {
        final int size;
        final ByteOrder byteOrder;
        final LinkedHashMap<String, FieldSpecInstance> nameToFSI = new LinkedHashMap();

        PatternSpec(ByteOrder byteOrder, FieldSpec ... specFields) {
            int position = 0;
            for (FieldSpec fs : specFields) {
                this.nameToFSI.put(fs.name, new FieldSpecInstance(fs, position));
                position += fs.size;
            }
            this.size = position;
            this.byteOrder = byteOrder;
        }

        ByteBuffer bufferFor() {
            ByteBuffer buf = ByteBuffer.allocate(this.size);
            buf.order(this.byteOrder);
            return buf;
        }

        public String toString() {
            return "PatternSpec{size=" + this.size + ", byteOrder=" + this.byteOrder + ", nameToFSI=" + this.nameToFSI + '}';
        }
    }

    static final class PatternInstance {
        final PatternSpec spec;
        final long position;
        final ByteBuffer buffer;

        PatternInstance(PatternSpec spec, long position, ByteBuffer buffer) {
            this.spec = spec;
            this.position = position;
            this.buffer = buffer.duplicate();
            this.buffer.order(spec.byteOrder);
            this.buffer.rewind();
            if (this.buffer.remaining() < spec.size) {
                throw new IllegalArgumentException("buffer isn't large or filled enough to hold spec");
            }
        }

        private Write prepWrite(String name, Function<FieldSpecInstance, ByteBuffer> bufferProvider, Consumer<ByteBuffer> bufferFiller) {
            FieldSpecInstance fsi = this.locateField(name);
            ByteBuffer buf = bufferProvider.apply(fsi);
            buf.order(this.spec.byteOrder);
            bufferFiller.accept(buf);
            buf.flip();
            return new Write(this.position + (long)fsi.position, buf);
        }

        Write writeAsBytes(String name, byte[] data) {
            return this.prepWrite(name, fsi -> {
                assert (data.length <= fsi.fs.size);
                return ByteBuffer.wrap(data);
            }, buf -> {});
        }

        private Write prepWrite(String name, Consumer<ByteBuffer> bufferFiller) {
            return this.prepWrite(name, fsi -> ByteBuffer.allocate(fsi.fs.size), bufferFiller);
        }

        Write writeByte(String name, byte data) {
            return this.prepWrite(name, buf -> buf.put(data));
        }

        Write writeShort(String name, short data) {
            return this.prepWrite(name, buf -> buf.putShort(data));
        }

        Write writeInt(String name, int data) {
            return this.prepWrite(name, buf -> buf.putInt(data));
        }

        Write writeLong(String name, long data) {
            return this.prepWrite(name, buf -> buf.putLong(data));
        }

        byte getByte(String name) {
            FieldSpecInstance fsi = this.locateField(name);
            return this.buffer.get(fsi.position);
        }

        byte[] getBytes(String name) {
            FieldSpecInstance fsi = this.locateField(name);
            return this.getBytes(fsi);
        }

        byte[] getBytes(FieldSpecInstance fsi) {
            byte[] result = new byte[fsi.fs.size];
            this.buffer.position(fsi.position);
            this.buffer.get(result, 0, result.length);
            return result;
        }

        short getShort(String name) {
            FieldSpecInstance fsi = this.locateField(name);
            assert (fsi.fs.size >= 2);
            return this.buffer.getShort(fsi.position);
        }

        int getUnsignedShort(String name) {
            return Short.toUnsignedInt(this.getShort(name));
        }

        int getInt(String name) {
            FieldSpecInstance fsi = this.locateField(name);
            assert (fsi.fs.size >= 4);
            return this.buffer.getInt(fsi.position);
        }

        long getUnsignedInt(String name) {
            return Integer.toUnsignedLong(this.getInt(name));
        }

        long getLong(String name) {
            FieldSpecInstance fsi = this.locateField(name);
            assert (fsi.fs.size >= 8);
            return this.buffer.getLong(fsi.position);
        }

        boolean validateMagic() {
            for (FieldSpecInstance fsi : this.spec.nameToFSI.values()) {
                if (fsi.fs.magic == null || Arrays.equals(fsi.fs.magic, this.getBytes(fsi))) continue;
                return false;
            }
            return true;
        }

        private FieldSpecInstance locateField(String name) {
            FieldSpecInstance fsi = this.spec.nameToFSI.get(name);
            if (fsi == null) {
                throw new IllegalArgumentException("no such field in my PatternSpec");
            }
            return fsi;
        }

        public String toString() {
            return "PatternInstance{spec=" + this.spec + ", position=" + this.position + ", buffer=" + this.buffer + '}';
        }
    }

    static final class Write {
        final long position;
        final ByteBuffer data;

        Write(long position, ByteBuffer data) {
            this.position = position;
            this.data = data;
        }

        public String toString() {
            return "Write{position=" + this.position + ", data=" + this.data + '}';
        }
    }

    static final class FieldSpecInstance {
        final FieldSpec fs;
        final int position;

        FieldSpecInstance(FieldSpec fs, int position) {
            this.fs = fs;
            this.position = position;
        }

        public String toString() {
            return "FieldSpecInstance{fs=" + this.fs + ", position=" + this.position + '}';
        }
    }

    static final class FieldSpec {
        final int size;
        final String name;
        final byte[] magic;

        FieldSpec(int size, String name, byte[] magic) {
            assert (size > 0 && name != null);
            this.size = size;
            this.name = name;
            this.magic = magic;
            if (magic != null && magic.length != size) {
                throw new IllegalArgumentException("magic bytes size mismatch");
            }
        }

        FieldSpec(int size, String name) {
            this.size = size;
            this.name = name;
            this.magic = null;
        }

        static FieldSpec of(int size, String name) {
            return new FieldSpec(size, name);
        }

        static FieldSpec of(int size, String name, byte[] magic) {
            return new FieldSpec(size, name, magic);
        }

        public String toString() {
            return "FieldSpec{size=" + this.size + ", name='" + this.name + '\'' + ", magic=" + Arrays.toString(this.magic) + '}';
        }
    }
}

