/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring;

import net.east301.keyring.BackendNotSupportedException;
import net.east301.keyring.KeyringBackend;
import net.east301.keyring.KeyringBackendFactory;
import net.east301.keyring.PasswordRetrievalException;
import net.east301.keyring.PasswordSaveException;
import net.east301.keyring.util.LockException;

public class Keyring {
    private KeyringBackend m_backend;

    public static Keyring create() throws BackendNotSupportedException {
        return new Keyring(KeyringBackendFactory.create());
    }

    public static Keyring create(String backendType) throws BackendNotSupportedException {
        return new Keyring(KeyringBackendFactory.create(backendType));
    }

    private Keyring(KeyringBackend backend) {
        this.m_backend = backend;
    }

    public KeyringBackend getBackend() {
        return this.m_backend;
    }

    public String getKeyStorePath() {
        return this.m_backend.getKeyStorePath();
    }

    public void setKeyStorePath(String path) {
        this.m_backend.setKeyStorePath(path);
    }

    public boolean isKeyStorePathRequired() {
        return this.m_backend.isKeyStorePathRequired();
    }

    public String getPassword(String service, String account) throws LockException, PasswordRetrievalException {
        return this.m_backend.getPassword(service, account);
    }

    public void setPassword(String service, String account, String password) throws LockException, PasswordSaveException {
        this.m_backend.setPassword(service, account, password);
    }
}

