/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring;

import java.util.ArrayList;
import net.east301.keyring.BackendNotSupportedException;
import net.east301.keyring.KeyringBackend;
import net.east301.keyring.memory.UncryptedMemoryBackend;
import net.east301.keyring.osx.OSXKeychainBackend;
import net.east301.keyring.windows.WindowsDPAPIBackend;

class KeyringBackendFactory {
    private static Object[][] KEYRING_BACKENDS = new Object[][]{{"OSXKeychain", OSXKeychainBackend.class}, {"WindowsDPAPI", WindowsDPAPIBackend.class}, {"UncryptedMemory", UncryptedMemoryBackend.class}};

    KeyringBackendFactory() {
    }

    public static KeyringBackend create() throws BackendNotSupportedException {
        for (Object[] entry : KEYRING_BACKENDS) {
            String name = (String)entry[0];
            Class cls = (Class)entry[1];
            KeyringBackend backend = KeyringBackendFactory.tryToCreateBackend(cls);
            if (backend == null) continue;
            return backend;
        }
        throw new BackendNotSupportedException("No available keyring backend found");
    }

    public static KeyringBackend create(String preferred) throws BackendNotSupportedException {
        Class backendClass = null;
        for (Object[] entry : KEYRING_BACKENDS) {
            String name = (String)entry[0];
            Class cls = (Class)entry[1];
            if (!name.equals(preferred)) continue;
            backendClass = cls;
            break;
        }
        if (backendClass == null) {
            throw new BackendNotSupportedException(String.format("The backend '%s' is not registered", preferred));
        }
        KeyringBackend backend = KeyringBackendFactory.tryToCreateBackend(backendClass);
        if (backend == null) {
            throw new BackendNotSupportedException(String.format("The backend '%s' is not supported", preferred));
        }
        return backend;
    }

    public static String[] getAllBackendNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Object[] entry : KEYRING_BACKENDS) {
            result.add((String)entry[0]);
        }
        return result.toArray(new String[0]);
    }

    private static KeyringBackend tryToCreateBackend(Class backendClass) {
        KeyringBackend backend;
        try {
            backend = (KeyringBackend)backendClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        if (!backend.isSupported()) {
            return null;
        }
        try {
            backend.setup();
        }
        catch (BackendNotSupportedException ex) {
            return null;
        }
        return backend;
    }
}

