/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring.memory;

import java.util.HashMap;
import java.util.Map;
import net.east301.keyring.KeyringBackend;
import net.east301.keyring.PasswordRetrievalException;
import net.east301.keyring.PasswordSaveException;
import net.east301.keyring.util.LockException;

public class UncryptedMemoryBackend
extends KeyringBackend {
    private HashMap<String[], String> m_store = new HashMap();

    public boolean isSupported() {
        return true;
    }

    public boolean isKeyStorePathRequired() {
        return false;
    }

    public String getPassword(String service, String account) throws LockException, PasswordRetrievalException {
        HashMap<String[], String> hashMap = this.m_store;
        synchronized (hashMap) {
            for (Map.Entry<String[], String> entries : this.m_store.entrySet()) {
                String[] serviceAndAccount = entries.getKey();
                if (!serviceAndAccount[0].equals(service) || !serviceAndAccount[1].equals(account)) continue;
                return entries.getValue();
            }
            throw new PasswordRetrievalException("Password related to the specified service and account is not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String service, String account, String password) throws LockException, PasswordSaveException {
        HashMap<String[], String> hashMap = this.m_store;
        synchronized (hashMap) {
            String[] targetKey = null;
            for (Map.Entry<String[], String> entries : this.m_store.entrySet()) {
                String[] serviceAndAccount = entries.getKey();
                if (!serviceAndAccount[0].equals(service) || !serviceAndAccount[1].equals(account)) continue;
                targetKey = serviceAndAccount;
                break;
            }
            if (targetKey == null) {
                targetKey = new String[]{service, account};
            }
            this.m_store.put(targetKey, password);
        }
    }

    public String getID() {
        return "UncryptedMemory";
    }
}

