/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring.osx;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import net.east301.keyring.BackendNotSupportedException;
import net.east301.keyring.KeyringBackend;
import net.east301.keyring.PasswordRetrievalException;
import net.east301.keyring.PasswordSaveException;
import net.east301.keyring.osx.NativeLibraryManager;

public class OSXKeychainBackend
extends KeyringBackend {
    public void setup() throws BackendNotSupportedException {
        NativeLibraryManager.loadNativeLibraries();
    }

    public boolean isSupported() {
        return Platform.isMac();
    }

    public boolean isKeyStorePathRequired() {
        return false;
    }

    public String getPassword(String service, String account) throws PasswordRetrievalException {
        byte[] accountBytes;
        byte[] serviceBytes;
        try {
            serviceBytes = service.getBytes("UTF-8");
            accountBytes = account.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new PasswordRetrievalException("Unsupported encoding 'UTF-8' specified");
        }
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        int status = NativeLibraryManager.Security.SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, dataLength, data, null);
        if (status != 0) {
            throw new PasswordRetrievalException(this.convertErrorCodeToMessage(status));
        }
        byte[] passwordBytes = data[0].getByteArray(0L, dataLength[0]);
        NativeLibraryManager.Security.SecKeychainItemFreeContent(null, data[0]);
        try {
            return new String(passwordBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new PasswordRetrievalException("Unsupported encoding 'UTF-8' specified");
        }
    }

    public void setPassword(String service, String account, String password) throws PasswordSaveException {
        byte[] passwordBytes;
        byte[] accountBytes;
        byte[] serviceBytes;
        try {
            serviceBytes = service.getBytes("UTF-8");
            accountBytes = account.getBytes("UTF-8");
            passwordBytes = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new PasswordSaveException("Unsupported encoding 'UTF-8' specified");
        }
        Pointer[] itemRef = new Pointer[1];
        int status = NativeLibraryManager.Security.SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, null, null, itemRef);
        if (status != 0 && status != -25300) {
            throw new PasswordSaveException(this.convertErrorCodeToMessage(status));
        }
        status = itemRef[0] != null ? NativeLibraryManager.Security.SecKeychainItemModifyContent(itemRef[0], null, passwordBytes.length, passwordBytes) : NativeLibraryManager.Security.SecKeychainAddGenericPassword(Pointer.NULL, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, passwordBytes.length, passwordBytes, null);
        if (status != 0) {
            throw new PasswordSaveException(this.convertErrorCodeToMessage(status));
        }
    }

    public String getID() {
        return "OSXKeychain";
    }

    private String convertErrorCodeToMessage(int errorCode) {
        Pointer msgPtr = NativeLibraryManager.Security.SecCopyErrorMessageString(errorCode, null);
        if (msgPtr == null) {
            return null;
        }
        int bufSize = (int)NativeLibraryManager.CoreFoundation.CFStringGetLength(msgPtr);
        char[] buf = new char[bufSize];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = NativeLibraryManager.CoreFoundation.CFStringGetCharacterAtIndex(msgPtr, i);
        }
        NativeLibraryManager.CoreFoundation.CFRelease(msgPtr);
        return new String(buf);
    }
}

