/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.east301.keyring.util.LockException;

public class FileBasedLock {
    private final String m_path;
    private File m_file;
    private FileChannel m_channel;
    private FileLock m_lock;

    public FileBasedLock(String path) {
        this.m_path = path;
    }

    public synchronized void lock() throws LockException {
        if (this.m_file != null || this.m_channel != null || this.m_lock != null) {
            throw new LockException("Already locked", null);
        }
        try {
            this.m_file = new File(this.m_path);
            this.m_file.createNewFile();
            this.m_channel = new RandomAccessFile(this.m_file, "rw").getChannel();
            this.m_lock = this.m_channel.lock();
        }
        catch (IOException ex) {
            throw new LockException("Failed to obtain lock", ex);
        }
    }

    public synchronized void release() throws LockException {
        try {
            if (this.m_lock != null && this.m_lock.isValid()) {
                this.m_lock.release();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FileBasedLock.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            if (this.m_channel != null && this.m_channel.isOpen()) {
                this.m_channel.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FileBasedLock.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.m_file = null;
        this.m_channel = null;
        this.m_lock = null;
    }

    public String getPath() {
        return this.m_path;
    }
}

