/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring.windows;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.east301.keyring.KeyringBackend;
import net.east301.keyring.PasswordRetrievalException;
import net.east301.keyring.PasswordSaveException;
import net.east301.keyring.util.FileBasedLock;
import net.east301.keyring.util.LockException;
import net.east301.keyring.windows.PasswordEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsDPAPIBackend
extends KeyringBackend {
    @Override
    public boolean isSupported() {
        return Platform.isWindows();
    }

    @Override
    public boolean isKeyStorePathRequired() {
        return true;
    }

    @Override
    public String getPassword(String service, String account) throws LockException, PasswordRetrievalException {
        FileBasedLock fileLock = new FileBasedLock(this.getLockPath());
        try {
            byte[] decryptedBytes;
            fileLock.lock();
            PasswordEntry targetEntry = null;
            for (PasswordEntry entry : this.loadPasswordEntries()) {
                if (!entry.getService().equals(service) || !entry.getAccount().equals(account)) continue;
                targetEntry = entry;
                break;
            }
            if (targetEntry == null) {
                throw new PasswordRetrievalException("Password related to the specified service and account is not found");
            }
            try {
                decryptedBytes = Crypt32Util.cryptUnprotectData((byte[])targetEntry.getPassword());
            }
            catch (Exception ex) {
                throw new PasswordRetrievalException("Failed to decrypt password");
            }
            try {
                String ex = new String(decryptedBytes, "UTF-8");
                return ex;
            }
            catch (UnsupportedEncodingException ex) {
                throw new PasswordRetrievalException("Unsupported encoding 'UTF-8' specified");
            }
        }
        finally {
            try {
                fileLock.release();
            }
            catch (Exception ex) {
                Logger.getLogger(WindowsDPAPIBackend.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(String service, String account, String password) throws LockException, PasswordSaveException {
        FileBasedLock fileLock = new FileBasedLock(this.getLockPath());
        try {
            byte[] encryptedBytes;
            fileLock.lock();
            try {
                encryptedBytes = Crypt32Util.cryptProtectData((byte[])password.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new PasswordSaveException("Unsupported encoding 'UTF-8' specified");
            }
            catch (Exception ex) {
                throw new PasswordSaveException("Failed to encrypt password");
            }
            ArrayList<PasswordEntry> entries = this.loadPasswordEntries();
            PasswordEntry targetEntry = null;
            for (PasswordEntry entry : entries) {
                if (!entry.getService().equals(service) || !entry.getAccount().equals(account)) continue;
                targetEntry = entry;
                break;
            }
            if (targetEntry != null) {
                targetEntry.setPassword(encryptedBytes);
            } else {
                entries.add(new PasswordEntry(service, account, encryptedBytes));
            }
            this.savePasswordEnetires(entries);
        }
        finally {
            try {
                fileLock.release();
            }
            catch (Exception ex) {
                Logger.getLogger(WindowsDPAPIBackend.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public String getID() {
        return "WindowsDPAPI";
    }

    public String getLockPath() {
        return this.m_keyStorePath + ".lock";
    }

    private ArrayList<PasswordEntry> loadPasswordEntries() {
        ArrayList<PasswordEntry> entries = new ArrayList<PasswordEntry>();
        try {
            FileInputStream fin = new FileInputStream(this.m_keyStorePath);
            ObjectInputStream oin = new ObjectInputStream(fin);
            entries.addAll(Arrays.asList((PasswordEntry[])oin.readObject()));
        }
        catch (Exception ex) {
            Logger.getLogger(WindowsDPAPIBackend.class.getName()).log(Level.SEVERE, null, ex);
        }
        return entries;
    }

    private void savePasswordEnetires(ArrayList<PasswordEntry> entries) throws PasswordSaveException {
        try {
            FileOutputStream fout = new FileOutputStream(this.m_keyStorePath);
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            oout.writeObject(entries.toArray(new PasswordEntry[0]));
        }
        catch (Exception ex) {
            Logger.getLogger(WindowsDPAPIBackend.class.getName()).log(Level.SEVERE, null, ex);
            throw new PasswordSaveException("Failed to save password entries to a file");
        }
    }
}

