/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.controller;

import java.util.concurrent.CompletableFuture;
import net.eightlives.friendlyssl.event.ChallengeTokenRequested;
import net.eightlives.friendlyssl.service.ChallengeTokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/.well-known/acme-challenge"})
public class CertificateChallengeController {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateChallengeController.class);
    private final ChallengeTokenStore challengeTokenStore;
    private final ApplicationEventPublisher applicationEventPublisher;

    public CertificateChallengeController(ChallengeTokenStore challengeTokenStore, ApplicationEventPublisher applicationEventPublisher) {
        this.challengeTokenStore = challengeTokenStore;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @GetMapping(value={"/{token}"}, produces={"text/plain"})
    public String getToken(@PathVariable String token) {
        LOG.debug("Challenge endpoint hit for token: " + token);
        String content = this.challengeTokenStore.getTokens().getOrDefault(token, "");
        CompletableFuture.runAsync(() -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new ChallengeTokenRequested(this, token)));
        LOG.debug("Returning this content to the ACME server: " + content);
        return content;
    }
}

