/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.controller;

import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.model.CertificateRenewal;
import net.eightlives.friendlyssl.service.CertificateCreateRenewService;
import net.eightlives.friendlyssl.service.PKCS12KeyStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnExpression(value="'${friendly-ssl.endpoints-include}'.contains('certificate')")
@RestController
@RequestMapping(value={"/friendly-ssl/certificate"})
public class CertificateController {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateController.class);
    private final FriendlySSLConfig config;
    private final CertificateCreateRenewService createRenewService;
    private final PKCS12KeyStoreService keyStoreService;

    public CertificateController(FriendlySSLConfig config, CertificateCreateRenewService createRenewService, PKCS12KeyStoreService keyStoreService) {
        this.config = config;
        this.createRenewService = createRenewService;
        this.keyStoreService = keyStoreService;
    }

    @GetMapping(path={"/order"}, produces={"application/json"})
    public ResponseEntity<CertificateRenewal> order() {
        boolean certificateExists = this.keyStoreService.getCertificate(this.config.getCertificateKeyAlias()).isPresent();
        CertificateRenewal certificateRenewal = certificateExists ? this.createRenewService.renewCertificate() : this.createRenewService.createCertificate();
        switch (certificateRenewal.getStatus()) {
            case ALREADY_VALID: 
            case SUCCESS: {
                return ResponseEntity.ok((Object)certificateRenewal);
            }
            case ERROR: {
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        }
        LOG.error("Unknown CertificateRenewal " + certificateRenewal.getStatus().name() + ". This is most likely a build problem.");
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }
}

