/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.controller;

import java.net.URI;
import javax.validation.Valid;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.model.TermsOfServiceAgreeRequest;
import net.eightlives.friendlyssl.service.TermsOfServiceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnExpression(value="'${friendly-ssl.endpoints-include}'.contains('tos')")
@RestController
@RequestMapping(value={"/friendly-ssl/tos"})
public class TermsOfServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(TermsOfServiceController.class);
    private final TermsOfServiceService termsOfServiceService;

    public TermsOfServiceController(TermsOfServiceService termsOfServiceService) {
        this.termsOfServiceService = termsOfServiceService;
    }

    @PostMapping(path={"/agree"}, consumes={"application/json"})
    public ResponseEntity<String> agreeToTermsOfService(@Valid @RequestBody TermsOfServiceAgreeRequest termsOfServiceLink) {
        String termsLink = termsOfServiceLink.getTermsOfServiceLink();
        try {
            this.termsOfServiceService.writeTermsLink(URI.create(termsLink), true);
            return ResponseEntity.ok().build();
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body((Object)("URI could not be created from terms link '" + termsLink + "'"));
        }
        catch (FriendlySSLException e) {
            LOG.error("Exception occurred while writing to terms of service file for terms link '" + termsLink + "'", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Exception occurred while writing to terms of service file for terms link '" + termsLink + "'"));
        }
    }
}

