/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.event.ChallengeTokenRequested;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.exception.UpdateFailedException;
import net.eightlives.friendlyssl.service.ChallengeTokenStore;
import net.eightlives.friendlyssl.service.UpdateCheckerService;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.exception.AcmeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ChallengeTokenRequestedListener
implements ApplicationListener<ChallengeTokenRequested> {
    private static final Logger LOG = LoggerFactory.getLogger(ChallengeTokenRequestedListener.class);
    private final FriendlySSLConfig config;
    private final UpdateCheckerService updateCheckerService;
    private final ChallengeTokenStore challengeTokenStore;
    private final Map<String, CompletableFuture<Void>> tokensToListenerFutures = new HashMap<String, CompletableFuture<Void>>();

    public ChallengeTokenRequestedListener(FriendlySSLConfig config, UpdateCheckerService updateCheckerService, ChallengeTokenStore challengeTokenStore) {
        this.config = config;
        this.updateCheckerService = updateCheckerService;
        this.challengeTokenStore = challengeTokenStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ChallengeTokenRequested event) {
        Map<String, CompletableFuture<Void>> map = this.tokensToListenerFutures;
        synchronized (map) {
            if (this.challengeTokenStore.getTokens().containsKey(event.getToken())) {
                this.tokensToListenerFutures.remove(event.getToken()).complete(null);
            }
        }
    }

    public CompletableFuture<Void> getChallengeTokenVerification(Http01Challenge challenge, Authorization authorization) {
        this.challengeTokenStore.setToken(challenge.getToken(), challenge.getAuthorization());
        CompletableFuture listenerFuture = new CompletableFuture();
        this.tokensToListenerFutures.put(challenge.getToken(), listenerFuture);
        try {
            challenge.trigger();
        }
        catch (AcmeException e) {
            this.challengeTokenStore.getTokens().remove(challenge.getToken());
            throw new FriendlySSLException(e);
        }
        return ((CompletableFuture)listenerFuture.orTimeout(this.config.getTokenRequestedTimeoutSeconds(), TimeUnit.SECONDS).thenRun(() -> {
            try {
                this.updateCheckerService.start((AcmeJsonResource)authorization).get(this.config.getAuthChallengeTimeoutSeconds(), TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                LOG.error("Timeout while checking for challenge status");
                throw new FriendlySSLException(e);
            }
            catch (InterruptedException | CancellationException | ExecutionException | UpdateFailedException e) {
                throw new FriendlySSLException(e);
            }
        })).whenComplete((aVoid, throwable) -> this.challengeTokenStore.getTokens().remove(challenge.getToken()));
    }
}

