/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.listener;

import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.factory.RecursiveTimerTaskFactory;
import net.eightlives.friendlyssl.service.AutoRenewService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class FriendlySSLApplicationListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(FriendlySSLApplicationListener.class);
    private final FriendlySSLConfig config;
    private final AutoRenewService autoRenewService;
    private final RecursiveTimerTaskFactory timerTaskFactory;
    private final ScheduledExecutorService timer;

    public FriendlySSLApplicationListener(FriendlySSLConfig config, AutoRenewService autoRenewService, RecursiveTimerTaskFactory timerTaskFactory, @Qualifier(value="ssl-certificate-monitor") ScheduledExecutorService timer) {
        this.config = config;
        this.autoRenewService = autoRenewService;
        this.timerTaskFactory = timerTaskFactory;
        this.timer = timer;
    }

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (this.config.isAutoRenewEnabled()) {
            LOG.info("Auto-renew SSL enabled, starting timer");
            this.timer.schedule(this.timerTaskFactory.create(this.timer, this::autoRenewTime), 1L, TimeUnit.SECONDS);
        }
    }

    private Instant autoRenewTime() {
        return this.autoRenewService.autoRenew().getTime();
    }
}

