/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.listener;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.Date;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCS12SafeBagBuilder;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEOutputEncryptorBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.shredzone.acme4j.util.KeyPairUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class KeystoreCheckListener
implements SpringApplicationRunListener {
    private static final Logger LOG = LoggerFactory.getLogger(KeystoreCheckListener.class);
    private static final String KEYSTORE_TYPE = "PKCS12";

    public KeystoreCheckListener(SpringApplication application, String[] args) {
    }

    public void starting() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        String keystoreLocation = environment.getProperty("friendly-ssl.keystore-file");
        String certificateFriendlyName = environment.getProperty("friendly-ssl.certificate-key-alias");
        String domain = environment.getProperty("friendly-ssl.domain");
        if (keystoreLocation != null && certificateFriendlyName != null && domain != null) {
            this.createSelfSignedIfKeystoreInvalid(keystoreLocation, certificateFriendlyName, domain);
        }
    }

    private void createSelfSignedIfKeystoreInvalid(String keystoreLocation, String certificateFriendlyName, String domain) {
        block11: {
            try {
                KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE);
                Path keystorePath = Path.of(keystoreLocation, new String[0]);
                java.security.cert.Certificate certificate = null;
                try {
                    if (keystorePath.getParent() != null) {
                        Files.createDirectories(keystorePath.getParent(), new FileAttribute[0]);
                    }
                    Files.createFile(keystorePath, new FileAttribute[0]);
                    LOG.info("Keystore file " + keystoreLocation + " created.");
                }
                catch (FileAlreadyExistsException e) {
                    store.load(new FileInputStream(keystorePath.toFile()), "".toCharArray());
                    LOG.info("Existing keystore file " + keystoreLocation + " loaded.");
                    certificate = store.getCertificate(certificateFriendlyName);
                    LOG.info("Existing keystore file " + keystoreLocation + " contains certificate named " + certificateFriendlyName + ": " + (certificate != null));
                }
                if (certificate != null) break block11;
                try (FileOutputStream file = new FileOutputStream(keystorePath.toFile());){
                    ((OutputStream)file).write(this.generateSelfSignedCertificateKeystore(certificateFriendlyName, domain));
                    LOG.info("Self-signed certificate named " + certificateFriendlyName);
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    LOG.error("Cannot load keystore file " + keystoreLocation + " - likely due to keystore having a password, which is unsupported.");
                }
                LOG.error("Error while validating certificate on startup", (Throwable)e);
            }
        }
    }

    private byte[] generateSelfSignedCertificateKeystore(String certificateFriendlyName, String domain) {
        try {
            KeyPair keyPair = KeyPairUtils.createKeyPair((int)2048);
            X500Name name = new X500Name("CN=" + domain + ",DC=FRIENDLYSSL,DC=EIGHTLIVES,DC=NET");
            AlgorithmIdentifier signatureAlgorithmId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WITHRSA");
            AlgorithmIdentifier digestAlgorithmId = new DefaultDigestAlgorithmIdentifierFinder().find(signatureAlgorithmId);
            ContentSigner signer = new BcRSAContentSignerBuilder(signatureAlgorithmId, digestAlgorithmId).build(PrivateKeyFactory.createKey((byte[])keyPair.getPrivate().getEncoded()));
            Certificate certificate = new X509v3CertificateBuilder(name, new BigInteger(64, new SecureRandom()), Date.from(Instant.now()), Date.from(Instant.now().plus(1L, ChronoUnit.DAYS)), name, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded())).build(signer).toASN1Structure();
            PKCS12SafeBagBuilder certBagBuilder = new PKCS12SafeBagBuilder(certificate);
            certBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(certificateFriendlyName));
            PKCS12SafeBag[] certBags = new PKCS12SafeBag[]{certBagBuilder.build()};
            JcaPKCS12SafeBagBuilder keyBagBuilder = new JcaPKCS12SafeBagBuilder(keyPair.getPrivate(), new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine())).setIterationCount(2048).build("".toCharArray()));
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(certificateFriendlyName));
            PKCS12PfxPduBuilder pfxBuilder = new PKCS12PfxPduBuilder();
            pfxBuilder.addEncryptedData(new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine())).setIterationCount(2048).build("".toCharArray()), certBags);
            pfxBuilder.addData(keyBagBuilder.build());
            BcPKCS12MacCalculatorBuilder macBuilder = new BcPKCS12MacCalculatorBuilder();
            macBuilder.setIterationCount(2048);
            PKCS12PfxPdu pfx = pfxBuilder.build((PKCS12MacCalculatorBuilder)macBuilder, "".toCharArray());
            return pfx.getEncoded("DL");
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            LOG.error("Error while generating self-signed certificate", e);
            throw new FriendlySSLException(e);
        }
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }
}

