/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.factory.AccountBuilderFactory;
import net.eightlives.friendlyssl.service.TermsOfServiceService;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeServerException;
import org.shredzone.acme4j.exception.AcmeUserActionRequiredException;
import org.shredzone.acme4j.util.KeyPairUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AcmeAccountService {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeAccountService.class);
    private static final URI ACCOUNT_NOT_EXISTS = URI.create("urn:ietf:params:acme:error:accountDoesNotExist");
    private final FriendlySSLConfig config;
    private final TermsOfServiceService termsOfServiceService;
    private final AccountBuilderFactory accountBuilderFactory;

    public AcmeAccountService(FriendlySSLConfig config, TermsOfServiceService termsOfServiceService, AccountBuilderFactory accountBuilderFactory) {
        this.config = config;
        this.termsOfServiceService = termsOfServiceService;
        this.accountBuilderFactory = accountBuilderFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Login getOrCreateAccountLogin(Session session) {
        URI termsOfServiceLink = this.termsOfServiceService.getTermsOfServiceLink(session);
        try (Reader keyReader = this.getKeyReader(this.config.getAccountPrivateKeyFile());){
            KeyPair accountKeyPair = KeyPairUtils.readKeyPair((Reader)keyReader);
            try {
                Login login = this.accountBuilderFactory.accountBuilder().useKeyPair(accountKeyPair).onlyExisting().createLogin(session);
                LOG.info("Using existing account login");
                Login login2 = login;
                return login2;
            }
            catch (AcmeServerException e) {
                block14: {
                    Login login;
                    block15: {
                        URI exceptionType = e.getProblem().getType();
                        if (!exceptionType.equals(ACCOUNT_NOT_EXISTS)) break block14;
                        if (!this.termsOfServiceService.termsAccepted(termsOfServiceLink)) {
                            this.termsOfServiceService.writeTermsLink(termsOfServiceLink, false);
                            throw new FriendlySSLException("Account does not exist. Terms of service must be accepted in file " + this.config.getTermsOfServiceFile() + " before account can be created");
                        }
                        LOG.info("Account does not exist. Creating account.");
                        login = this.accountBuilderFactory.accountBuilder().useKeyPair(accountKeyPair).addEmail(this.config.getAccountEmail()).agreeToTermsOfService().createLogin(session);
                        if (keyReader == null) break block15;
                        keyReader.close();
                    }
                    return login;
                }
                throw e;
            }
        }
        catch (AcmeUserActionRequiredException e) {
            LOG.error("Account retrieval failed due to user action required (terms of service probably changed). See " + e.getInstance() + " and if the terms of service did change, accept the terms in file " + this.config.getTermsOfServiceFile(), (Throwable)e);
            this.termsOfServiceService.writeTermsLink(termsOfServiceLink, false);
            throw new FriendlySSLException(e);
        }
        catch (IOException | AcmeException e) {
            LOG.error("Error while retrieving or creating ACME Login");
            throw new FriendlySSLException(e);
        }
    }

    private Reader getKeyReader(String filename) throws IOException {
        try {
            return Files.newBufferedReader(Path.of(filename, new String[0]));
        }
        catch (NoSuchFileException e) {
            KeyPair accountKeyPair = KeyPairUtils.createKeyPair((int)2048);
            try (BufferedWriter fileWriter = Files.newBufferedWriter(Path.of(filename, new String[0]), new OpenOption[0]);){
                KeyPairUtils.writeKeyPair((KeyPair)accountKeyPair, (Writer)fileWriter);
                ByteArrayOutputStream keyBytes = new ByteArrayOutputStream();
                KeyPairUtils.writeKeyPair((KeyPair)accountKeyPair, (Writer)new OutputStreamWriter(keyBytes));
                keyBytes.flush();
                InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(keyBytes.toByteArray()));
                return inputStreamReader;
            }
        }
    }
}

