/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.model.CertificateRenewal;
import net.eightlives.friendlyssl.model.CertificateRenewalStatus;
import net.eightlives.friendlyssl.service.CertificateCreateRenewService;
import net.eightlives.friendlyssl.service.PKCS12KeyStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AutoRenewService {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRenewService.class);
    private final FriendlySSLConfig config;
    private final CertificateCreateRenewService createRenewService;
    private final PKCS12KeyStoreService keyStoreService;
    private final Clock clock;

    public AutoRenewService(FriendlySSLConfig config, CertificateCreateRenewService createRenewService, PKCS12KeyStoreService keyStoreService, Clock clock) {
        this.config = config;
        this.createRenewService = createRenewService;
        this.keyStoreService = keyStoreService;
        this.clock = clock;
    }

    public CertificateRenewal autoRenew() {
        LOG.info("Auto-renew starting...");
        return this.keyStoreService.getCertificate(this.config.getCertificateKeyAlias()).map(certificate -> {
            Instant renewTime = Instant.ofEpochMilli(certificate.getNotAfter().getTime());
            LOG.info("Existing certificate expiration time is " + DateTimeFormatter.RFC_1123_DATE_TIME.format(renewTime.atZone(ZoneOffset.UTC)));
            if (this.clock.instant().plus((long)this.config.getAutoRenewalHoursBefore(), ChronoUnit.HOURS).isBefore(renewTime)) {
                return new CertificateRenewal(CertificateRenewalStatus.ALREADY_VALID, renewTime.minus(this.config.getAutoRenewalHoursBefore(), ChronoUnit.HOURS));
            }
            return this.createRenewService.renewCertificate();
        }).orElseGet(this.createRenewService::createCertificate);
    }
}

