/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.security.KeyPair;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.model.CertificateRenewal;
import net.eightlives.friendlyssl.model.CertificateRenewalStatus;
import net.eightlives.friendlyssl.service.AcmeAccountService;
import net.eightlives.friendlyssl.service.CertificateOrderHandlerService;
import net.eightlives.friendlyssl.service.PKCS12KeyStoreService;
import net.eightlives.friendlyssl.service.SSLContextService;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.util.KeyPairUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CertificateCreateRenewService {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateCreateRenewService.class);
    private final FriendlySSLConfig config;
    private final AcmeAccountService accountService;
    private final PKCS12KeyStoreService keyStoreService;
    private final CertificateOrderHandlerService certificateOrderHandlerService;
    private final SSLContextService sslContextService;
    private final Clock clock;

    public CertificateCreateRenewService(FriendlySSLConfig config, AcmeAccountService accountService, PKCS12KeyStoreService keyStoreService, CertificateOrderHandlerService certificateOrderHandlerService, SSLContextService sslContextService, Clock clock) {
        this.config = config;
        this.accountService = accountService;
        this.keyStoreService = keyStoreService;
        this.certificateOrderHandlerService = certificateOrderHandlerService;
        this.sslContextService = sslContextService;
        this.clock = clock;
    }

    public CertificateRenewal createCertificate() {
        LOG.info("Starting certificate create");
        return this.orderCertificate(KeyPairUtils.createKeyPair((int)2048));
    }

    public CertificateRenewal renewCertificate() {
        LOG.info("Starting certificate renew");
        KeyPair domainKeyPair = this.keyStoreService.getKeyPair(this.config.getCertificateKeyAlias());
        return domainKeyPair == null ? this.createCertificate() : this.orderCertificate(domainKeyPair);
    }

    private CertificateRenewal orderCertificate(KeyPair domainKeyPair) {
        try {
            Session session = new Session(this.config.getAcmeSessionUrl());
            Login login = this.accountService.getOrCreateAccountLogin(session);
            LOG.info("Certificate account login accessed");
            LOG.info("Beginning certificate order.");
            Certificate certificate = this.certificateOrderHandlerService.handleCertificateOrder(login, domainKeyPair);
            Instant certificateExpiration = Instant.ofEpochMilli(certificate.getCertificate().getNotAfter().getTime());
            LOG.info("Certificate renewal successful. New certificate expiration time is " + DateTimeFormatter.RFC_1123_DATE_TIME.format(certificateExpiration.atZone(ZoneOffset.UTC)));
            LOG.info("Reloading SSL context...");
            this.sslContextService.reloadSSLConfig();
            return new CertificateRenewal(CertificateRenewalStatus.SUCCESS, certificateExpiration.minus(this.config.getAutoRenewalHoursBefore(), ChronoUnit.HOURS));
        }
        catch (IllegalArgumentException e) {
            LOG.error("acmeSessionUrl " + this.config.getAcmeSessionUrl() + " is invalid", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while ordering certificate, retry in " + this.config.getErrorRetryWaitHours() + " hours", (Throwable)e);
            return new CertificateRenewal(CertificateRenewalStatus.ERROR, this.clock.instant().plus((long)this.config.getErrorRetryWaitHours(), ChronoUnit.HOURS));
        }
    }
}

