/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.exception.KeyStoreGeneratorException;
import net.eightlives.friendlyssl.service.CertificateOrderService;
import net.eightlives.friendlyssl.service.PKCS12KeyStoreService;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Login;
import org.springframework.stereotype.Component;

@Component
public class CertificateOrderHandlerService {
    private final FriendlySSLConfig config;
    private final CertificateOrderService certificateOrderService;
    private final PKCS12KeyStoreService keyStoreService;

    public CertificateOrderHandlerService(FriendlySSLConfig config, CertificateOrderService certificateOrderService, PKCS12KeyStoreService keyStoreService) {
        this.config = config;
        this.certificateOrderService = certificateOrderService;
        this.keyStoreService = keyStoreService;
    }

    public Certificate handleCertificateOrder(Login login, KeyPair domainKeyPair) {
        return this.certificateOrderService.orderCertificate(this.config.getDomain(), login, domainKeyPair).map(certificate -> {
            try (OutputStream file = Files.newOutputStream(Path.of(this.config.getKeystoreFile(), new String[0]), new OpenOption[0]);){
                byte[] keyStore = this.keyStoreService.generateKeyStore(certificate.getCertificateChain(), domainKeyPair.getPrivate());
                file.write(keyStore);
            }
            catch (IOException | KeyStoreGeneratorException e) {
                throw new FriendlySSLException(e);
            }
            return certificate;
        }).orElseThrow(() -> new FriendlySSLException("Certificate was not returned"));
    }
}

