/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.security.KeyPair;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.exception.UpdateFailedException;
import net.eightlives.friendlyssl.service.CSRService;
import net.eightlives.friendlyssl.service.ChallengeProcessorService;
import net.eightlives.friendlyssl.service.UpdateCheckerService;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.exception.AcmeException;
import org.springframework.stereotype.Component;

@Component
public class CertificateOrderService {
    private final FriendlySSLConfig config;
    private final ChallengeProcessorService challengeProcessorService;
    private final CSRService csrService;
    private final UpdateCheckerService updateCheckerService;

    public CertificateOrderService(FriendlySSLConfig config, ChallengeProcessorService challengeProcessorService, CSRService csrService, UpdateCheckerService updateCheckerService) {
        this.config = config;
        this.challengeProcessorService = challengeProcessorService;
        this.csrService = csrService;
        this.updateCheckerService = updateCheckerService;
    }

    public Optional<Certificate> orderCertificate(String domain, Login login, KeyPair domainKeyPair) {
        try {
            Order order = login.getAccount().newOrder().domain(domain).create();
            this.challengeProcessorService.process(order.getAuthorizations()).get();
            byte[] csr = this.csrService.generateCSR(domain, domainKeyPair);
            order.execute(csr);
            this.updateCheckerService.start((AcmeJsonResource)order).get(this.config.getOrderTimeoutSeconds(), TimeUnit.SECONDS);
            return Optional.ofNullable(order.getCertificate());
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException | UpdateFailedException | AcmeException e) {
            throw new FriendlySSLException(e);
        }
    }
}

