/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.listener.ChallengeTokenRequestedListener;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.springframework.stereotype.Component;

@Component
public class ChallengeProcessorService {
    private final ChallengeTokenRequestedListener challengeTokenRequestedListener;

    public ChallengeProcessorService(ChallengeTokenRequestedListener challengeTokenRequestedListener) {
        this.challengeTokenRequestedListener = challengeTokenRequestedListener;
    }

    public CompletableFuture<Void> process(List<Authorization> authorizations) {
        CompletableFuture[] challenges = (CompletableFuture[])authorizations.stream().filter(auth -> auth.getStatus() != Status.VALID).map(auth -> {
            Http01Challenge challenge = (Http01Challenge)auth.findChallenge("http-01");
            if (challenge == null) {
                throw new FriendlySSLException("HTTP Challenge does not exist");
            }
            return new AuthorizationAndChallenge((Authorization)auth, challenge);
        }).collect(Collectors.toList()).stream().map(this::processAuth).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(challenges);
    }

    private CompletableFuture<Void> processAuth(AuthorizationAndChallenge authAndChallenge) {
        return this.challengeTokenRequestedListener.getChallengeTokenVerification(authAndChallenge.challenge, authAndChallenge.authorization);
    }

    private static final class AuthorizationAndChallenge {
        public final Authorization authorization;
        public final Http01Challenge challenge;

        private AuthorizationAndChallenge(Authorization authorization, Http01Challenge challenge) {
            this.authorization = authorization;
            this.challenge = challenge;
        }
    }
}

