/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import java.util.Optional;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.exception.KeyStoreGeneratorException;
import net.eightlives.friendlyssl.service.LocalIdGeneratorService;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEOutputEncryptorBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PKCS12KeyStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(PKCS12KeyStoreService.class);
    private static final String ROOT_FRIENDLY_NAME = "root";
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String KEYFACTORY_TYPE = "RSA";
    private final FriendlySSLConfig config;
    private final LocalIdGeneratorService localIdGeneratorService;

    public PKCS12KeyStoreService(FriendlySSLConfig config, LocalIdGeneratorService localIdGeneratorService) {
        this.config = config;
        this.localIdGeneratorService = localIdGeneratorService;
    }

    public byte[] generateKeyStore(List<X509Certificate> certificates, PrivateKey privateKey) {
        try {
            byte[] localKeyBytes = this.localIdGeneratorService.generate();
            PKCS12SafeBag[] certBags = new PKCS12SafeBag[certificates.size()];
            for (int i = certificates.size() - 1; i >= 0; --i) {
                JcaPKCS12SafeBagBuilder certBagBuilder = new JcaPKCS12SafeBagBuilder(certificates.get(i));
                if (i == 0) {
                    certBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(this.config.getCertificateKeyAlias()));
                    certBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)new DEROctetString(localKeyBytes));
                } else {
                    certBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(ROOT_FRIENDLY_NAME));
                }
                certBags[i] = certBagBuilder.build();
            }
            JcaPKCS12SafeBagBuilder keyBagBuilder = new JcaPKCS12SafeBagBuilder(privateKey, new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine())).setIterationCount(2048).build("".toCharArray()));
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(this.config.getCertificateKeyAlias()));
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)new DEROctetString(localKeyBytes));
            PKCS12PfxPduBuilder pfxBuilder = new PKCS12PfxPduBuilder();
            pfxBuilder.addEncryptedData(new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine())).setIterationCount(2048).build("".toCharArray()), certBags);
            pfxBuilder.addData(keyBagBuilder.build());
            BcPKCS12MacCalculatorBuilder macBuilder = new BcPKCS12MacCalculatorBuilder();
            macBuilder.setIterationCount(2048);
            PKCS12PfxPdu pfx = pfxBuilder.build((PKCS12MacCalculatorBuilder)macBuilder, "".toCharArray());
            return pfx.getEncoded("DL");
        }
        catch (IOException | PKCSException e) {
            throw new KeyStoreGeneratorException(e);
        }
    }

    public KeyPair getKeyPair(String keyAlias) {
        try {
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE);
            store.load(Files.newInputStream(Path.of(this.config.getKeystoreFile(), new String[0]), new OpenOption[0]), "".toCharArray());
            KeyFactory keyFactory = KeyFactory.getInstance(KEYFACTORY_TYPE);
            Key key = store.getKey(keyAlias, "".toCharArray());
            if (key == null) {
                LOG.error("Private key alias " + keyAlias + " not found in keystore " + this.config.getKeystoreFile() + " when loading keystore");
                return null;
            }
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(key.getEncoded()));
            Certificate certificate = store.getCertificate(keyAlias);
            if (certificate == null) {
                LOG.error("Certificate with alias " + keyAlias + " not found in keystore " + this.config.getKeystoreFile() + " when loading keystore");
                return null;
            }
            return new KeyPair(certificate.getPublicKey(), privateKey);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            LOG.error("Exception while accessing keystore", (Throwable)e);
            return null;
        }
    }

    public Optional<X509Certificate> getCertificate(String keyAlias) {
        try {
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE);
            try {
                store.load(Files.newInputStream(Path.of(this.config.getKeystoreFile(), new String[0]), new OpenOption[0]), "".toCharArray());
            }
            catch (NoSuchFileException e) {
                return Optional.empty();
            }
            Certificate certificate = store.getCertificate(keyAlias);
            if (certificate instanceof X509Certificate) {
                return Optional.of((X509Certificate)certificate);
            }
            return Optional.empty();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("Exception while accessing keystore", (Throwable)e);
            return Optional.empty();
        }
    }
}

