/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.eightlives.friendlyssl.config.FriendlySSLConfig;
import net.eightlives.friendlyssl.exception.FriendlySSLException;
import net.eightlives.friendlyssl.model.TermsOfService;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.exception.AcmeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TermsOfServiceService {
    private static final Logger LOG = LoggerFactory.getLogger(TermsOfServiceService.class);
    private static final String AGREE_TO_TERMS_YES = "YES";
    private static final String AGREE_TO_TERMS_NO = "NO";
    private final FriendlySSLConfig config;
    private final ObjectMapper objectMapper;

    public TermsOfServiceService(FriendlySSLConfig config, ObjectMapper objectMapper) {
        this.config = config;
        this.objectMapper = objectMapper;
    }

    public URI getTermsOfServiceLink(Session session) {
        URI termsOfServiceLink;
        try {
            termsOfServiceLink = session.getMetadata().getTermsOfService();
        }
        catch (AcmeException e) {
            LOG.error("Could not retrieve terms of service link", (Throwable)e);
            throw new FriendlySSLException(e);
        }
        if (termsOfServiceLink == null) {
            LOG.error("Could not retrieve terms of service link");
            throw new FriendlySSLException("Terms of service should not be null. There may be a problem with the provider.");
        }
        return termsOfServiceLink;
    }

    public boolean termsAccepted(URI termsOfServiceLink) {
        try {
            TermsOfService[] termsOfService = (TermsOfService[])this.objectMapper.readValue(Files.newInputStream(Path.of(this.config.getTermsOfServiceFile(), new String[0]), new OpenOption[0]), TermsOfService[].class);
            return Stream.of(termsOfService).filter(tos -> termsOfServiceLink.toString().equals(tos.getTermsOfService())).anyMatch(tos -> tos.getAgreeToTerms().equalsIgnoreCase(AGREE_TO_TERMS_YES));
        }
        catch (NoSuchFileException e) {
            return false;
        }
        catch (IOException e) {
            LOG.error("Exception while trying to read from terms of service file " + this.config.getTermsOfServiceFile(), (Throwable)e);
            throw new FriendlySSLException(e);
        }
    }

    public void writeTermsLink(URI termsOfServiceLink, boolean accept) {
        Path termsOfServiceFile = Path.of(this.config.getTermsOfServiceFile(), new String[0]);
        try {
            Files.createFile(termsOfServiceFile, new FileAttribute[0]);
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((Writer)Files.newBufferedWriter(termsOfServiceFile, new OpenOption[0]), (Object)new TermsOfService[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOG.error("Exception while creating terms of service file " + this.config.getTermsOfServiceFile(), (Throwable)e);
            throw new FriendlySSLException(e);
        }
        try {
            TermsOfService[] termsOfService = (TermsOfService[])this.objectMapper.readValue((Reader)Files.newBufferedReader(termsOfServiceFile), TermsOfService[].class);
            List allTerms = Stream.of(termsOfService).filter(tos -> !termsOfServiceLink.toString().equals(tos.getTermsOfService())).collect(Collectors.toList());
            allTerms.add(new TermsOfService(termsOfServiceLink.toString(), accept ? AGREE_TO_TERMS_YES : AGREE_TO_TERMS_NO));
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((Writer)Files.newBufferedWriter(termsOfServiceFile, new OpenOption[0]), allTerms);
        }
        catch (IOException e) {
            LOG.error("Exception while trying to read or write to terms of service file " + this.config.getTermsOfServiceFile(), (Throwable)e);
            throw new FriendlySSLException(e);
        }
    }
}

