/*
 * Decompiled with CFR 0.152.
 */
package net.eightlives.friendlyssl.service;

import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.eightlives.friendlyssl.exception.UpdateFailedException;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeRetryAfterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UpdateCheckerService {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCheckerService.class);
    private final ScheduledExecutorService scheduler;
    private final Clock clock;

    public UpdateCheckerService(@Qualifier(value="update-checker-scheduler") ScheduledExecutorService scheduler, Clock clock) {
        this.scheduler = scheduler;
        this.clock = clock;
    }

    public ScheduledFuture<Void> start(AcmeJsonResource resource) {
        long millisecondsUntilRetry = this.updateAcmeJsonResource(resource);
        return this.scheduler.schedule(() -> {
            while (true) {
                try {
                    while (true) {
                        Status status = resource.getJSON().get("status").asStatus();
                        switch (status) {
                            case VALID: {
                                LOG.info("Resource is valid");
                                return;
                            }
                            case INVALID: {
                                LOG.error("Resource is invalid");
                                throw new UpdateFailedException();
                            }
                        }
                        LOG.info("Resource status is " + status + ". Updating...");
                        Thread.sleep(this.updateAcmeJsonResource(resource));
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }, millisecondsUntilRetry, TimeUnit.MILLISECONDS);
    }

    private long updateAcmeJsonResource(AcmeJsonResource resource) {
        try {
            resource.update();
            return 0L;
        }
        catch (AcmeRetryAfterException e) {
            return this.clock.instant().until(e.getRetryAfter(), ChronoUnit.MILLIS);
        }
        catch (AcmeException e) {
            throw new UpdateFailedException();
        }
    }
}

