/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.options.Either;
import net.emaze.dysfunctional.options.Maybe;

public class EitherFromArray
extends JsonDeserializer<Either<?, ?>> {
    private final JavaType maybeLeftType;
    private final JavaType maybeRightType;

    public EitherFromArray(JavaType leftType, JavaType rightType) {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        this.maybeLeftType = typeFactory.constructParametricType(Maybe.class, new JavaType[]{leftType});
        this.maybeRightType = typeFactory.constructParametricType(Maybe.class, new JavaType[]{rightType});
    }

    public Either<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        dbc.state((JsonToken.START_ARRAY == jp.getCurrentToken() ? 1 : 0) != 0, (String)"expected a START_ARRAY token", (Object[])new Object[0]);
        jp.nextToken();
        Maybe maybeLeft = (Maybe)ctxt.findContextualValueDeserializer(this.maybeLeftType, null).deserialize(jp, ctxt);
        jp.nextToken();
        Maybe maybeRight = (Maybe)ctxt.findContextualValueDeserializer(this.maybeRightType, null).deserialize(jp, ctxt);
        dbc.state((JsonToken.END_ARRAY == jp.nextToken() ? 1 : 0) != 0, (String)"expected an END_ARRAY token", (Object[])new Object[0]);
        return new Either(maybeLeft.optional(), maybeRight.optional());
    }
}

