/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.tuples.Pair;

public class PairFromArray
extends JsonDeserializer<Pair<?, ?>> {
    private final JavaType firstType;
    private final JavaType secondType;

    public PairFromArray(JavaType firstType, JavaType secondType) {
        this.firstType = firstType;
        this.secondType = secondType;
    }

    public Pair<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        dbc.state((JsonToken.START_ARRAY == jp.getCurrentToken() ? 1 : 0) != 0, (String)"expected a START_ARRAY token", (Object[])new Object[0]);
        jp.nextToken();
        Object firstValue = jp.getCurrentToken() == JsonToken.VALUE_NULL ? null : ctxt.findContextualValueDeserializer(this.firstType, null).deserialize(jp, ctxt);
        jp.nextToken();
        Object secondValue = jp.getCurrentToken() == JsonToken.VALUE_NULL ? null : ctxt.findContextualValueDeserializer(this.secondType, null).deserialize(jp, ctxt);
        dbc.state((JsonToken.END_ARRAY == jp.nextToken() ? 1 : 0) != 0, (String)"expected an END_ARRAY token", (Object[])new Object[0]);
        return Pair.of((Object)firstValue, (Object)secondValue);
    }
}

