/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.jackson.ranges;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.emaze.dysfunctional.Ranges;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.dysfunctional.ranges.Range;

public class RangeFromHash<T>
extends JsonDeserializer<Range<T>> {
    private final JavaType nestedType;
    private final Ranges<T> ranges;

    public RangeFromHash(JavaType nestedType, Ranges<T> ranges) {
        this.nestedType = nestedType;
        this.ranges = ranges;
    }

    public Range<T> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JavaType containedType = ctxt.getTypeFactory().constructParametrizedType(DenseRangeSerializedForm.class, DenseRangeSerializedForm.class, new JavaType[]{this.nestedType});
        CollectionType serializedType = ctxt.getTypeFactory().constructCollectionType(ArrayList.class, containedType);
        List serializedValue = (List)ctxt.findContextualValueDeserializer((JavaType)serializedType, null).deserialize(jp, ctxt);
        Iterator iterator = serializedValue.iterator();
        DenseRangeSerializedForm first = (DenseRangeSerializedForm)iterator.next();
        Range range = this.ranges.rightHalfOpen(first.b, first.e.optional());
        while (iterator.hasNext()) {
            DenseRangeSerializedForm current = (DenseRangeSerializedForm)iterator.next();
            range = this.ranges.union(range, this.ranges.rightHalfOpen(current.b, current.e.optional()));
        }
        return range;
    }

    public static class DenseRangeSerializedForm<T> {
        private T b;
        private Maybe<T> e;

        public T getB() {
            return this.b;
        }

        public void setB(T b) {
            this.b = b;
        }

        public Maybe<T> getE() {
            return this.e;
        }

        public void setE(Maybe<T> e) {
            this.e = e;
        }
    }
}

