/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.jackson.ranges;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import net.emaze.dysfunctional.Ranges;
import net.emaze.dysfunctional.jackson.ranges.RangeFromHash;
import net.emaze.dysfunctional.jackson.ranges.RangeToHash;
import net.emaze.dysfunctional.ranges.Range;

public class RangeModule<T>
extends SimpleModule {
    private final Ranges<T> ranges;
    private final Class<T> typeParameter;

    public RangeModule(Ranges<T> ranges, Class<T> typeParameter) {
        super("dysfunctional-range-module", new Version(2, 0, 0, null, "net.emaze", "emaze-dysfunctional-jackson"));
        this.ranges = ranges;
        this.typeParameter = typeParameter;
    }

    public Object getTypeId() {
        return String.format("%s-%s", ((Object)((Object)this)).getClass().getName(), this.typeParameter.getCanonicalName());
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new Serializers.Base(){

            public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
                if (Range.class.isAssignableFrom(type.getRawClass())) {
                    return new RangeToHash();
                }
                return null;
            }
        });
        context.addDeserializers((Deserializers)new Deserializers.Base(){

            public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                if (Range.class.isAssignableFrom(type.getRawClass()) && type.containedType(0).hasRawClass(RangeModule.this.typeParameter)) {
                    return new RangeFromHash(type.containedType(0), RangeModule.this.ranges);
                }
                return null;
            }
        });
    }
}

