/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.maple.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.maple.Accessor;
import net.emaze.maple.Converter;
import net.emaze.maple.Converters;
import net.emaze.maple.Mutator;
import net.emaze.maple.beans.Beans;
import org.springframework.core.ResolvableType;

public class BeanToBeanConverter
implements Converter {
    private final Beans beans;

    public BeanToBeanConverter(Beans beans) {
        this.beans = beans;
    }

    @Override
    public boolean canConvert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        return this.beans.constructor(targetType.resolve()).hasValue();
    }

    @Override
    public Maybe<?> convert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        try {
            Constructor ctor = (Constructor)this.beans.constructor(targetType.resolve()).value();
            Object target = ctor.newInstance(new Object[0]);
            Class targetClass = targetType.resolve();
            Map<String, Mutator> targetMutators = this.beans.mutators(targetClass);
            Class sourceClass = sourceType.resolve();
            Map<String, Accessor> sourceAccessors = this.beans.accessors(sourceClass);
            for (Map.Entry<String, Accessor> entry : sourceAccessors.entrySet()) {
                String field = entry.getKey();
                if (!targetMutators.containsKey(field)) continue;
                Accessor accessor = entry.getValue();
                Mutator mutator = targetMutators.get(field);
                Maybe<?> converted = converters.convert(accessor.type(sourceType), accessor.access(source), mutator.type(targetType));
                converted.forEach(c -> mutator.mutate(target, c));
            }
            return Maybe.just(target);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            return Maybe.nothing();
        }
    }
}

