/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.maple.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.emaze.dysfunctional.options.Maybe;
import net.emaze.maple.Converter;
import net.emaze.maple.Converters;
import org.springframework.core.ResolvableType;

public class MapToMapConverter
implements Converter {
    @Override
    public boolean canConvert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        return Map.class.isAssignableFrom(targetType.resolve()) && source instanceof Map;
    }

    @Override
    public Maybe<?> convert(Converters converters, ResolvableType sourceType, Object source, ResolvableType targetType) {
        Map<Object, Object> r = this.createMap(targetType.getRawClass(), source);
        ResolvableType sourceKeyType = sourceType.getGeneric(new int[]{0});
        ResolvableType sourceValueType = sourceType.getGeneric(new int[]{1});
        ResolvableType targetKeyType = targetType.getGeneric(new int[]{0});
        ResolvableType targetValueType = targetType.getGeneric(new int[]{1});
        for (Map.Entry sourceEntry : ((Map)source).entrySet()) {
            Maybe<?> k = converters.convert(sourceKeyType, sourceEntry.getKey(), targetKeyType);
            Maybe<?> v = converters.convert(sourceValueType, sourceEntry.getValue(), targetValueType);
            if (!k.hasValue() || !v.hasValue()) {
                return Maybe.nothing();
            }
            r.put(k.value(), v.value());
        }
        return Maybe.just(r);
    }

    private Map<Object, Object> createMap(Class<?> targetClass, Object source) {
        if (SortedMap.class.isAssignableFrom(targetClass)) {
            return new TreeMap<Object, Object>(((SortedMap)source).comparator());
        }
        return new HashMap<Object, Object>();
    }
}

