/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Setting;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.generation.DecoderGenerator;
import net.emustudio.edigen.generation.DisassemblerGenerator;
import net.emustudio.edigen.nodes.Specification;
import net.emustudio.edigen.parser.ParseException;
import net.emustudio.edigen.parser.Parser;
import net.emustudio.edigen.passes.DetectAmbiguousVisitor;
import net.emustudio.edigen.passes.DetectRootRulesVisitor;
import net.emustudio.edigen.passes.DetectUnreachableFormatsVisitor;
import net.emustudio.edigen.passes.DetectUnusedRulesVisitor;
import net.emustudio.edigen.passes.GroupVisitor;
import net.emustudio.edigen.passes.MergePatternsVisitor;
import net.emustudio.edigen.passes.NarrowMasksVisitor;
import net.emustudio.edigen.passes.PushDownVariantsVisitor;
import net.emustudio.edigen.passes.RemoveUnreachablePatternsVisitor;
import net.emustudio.edigen.passes.ResolveNamesVisitor;
import net.emustudio.edigen.passes.SemanticCheckVisitor;
import net.emustudio.edigen.passes.SortVisitor;
import net.emustudio.edigen.passes.SplitVisitor;

public class Translator {
    private static final PrintStream DEBUG_STREAM = System.out;
    private final Map<Setting, String> settings;

    public Translator(Map<Setting, String> settings) {
        this.settings = settings;
    }

    public void translate() throws IOException, ParseException, SemanticException {
        try (BufferedReader input = new BufferedReader(new FileReader(this.settings.get((Object)Setting.SPECIFICATION)));){
            Parser parser = new Parser(input);
            Specification specification = parser.parse();
            this.transform(specification);
            DecoderGenerator decoder = new DecoderGenerator(specification.getDecoder(), this.settings.get((Object)Setting.DECODER_NAME));
            decoder.setOutputDirectory(this.settings.get((Object)Setting.DECODER_DIRECTORY));
            decoder.setTemplateFile(this.settings.get((Object)Setting.DECODER_TEMPLATE));
            decoder.generate();
            DisassemblerGenerator disassembler = new DisassemblerGenerator(specification.getDisassembler(), this.settings.get((Object)Setting.DISASSEMBLER_NAME), this.settings.get((Object)Setting.DECODER_NAME));
            disassembler.setOutputDirectory(this.settings.get((Object)Setting.DISASSEMBLER_DIRECTORY));
            disassembler.setTemplateFile(this.settings.get((Object)Setting.DISASSEMBLER_TEMPLATE));
            disassembler.generate();
        }
    }

    private void transform(Specification specification) throws SemanticException {
        Visitor detectUnusedRulesVisitor = this.settings.containsKey((Object)Setting.IGNORE_UNUSED_RULES) ? new Visitor(){} : new DetectUnusedRulesVisitor();
        Visitor[] transforms = new Visitor[]{new ResolveNamesVisitor(), new DetectRootRulesVisitor(), detectUnusedRulesVisitor, new SemanticCheckVisitor(), new MergePatternsVisitor(), new SortVisitor(), new SplitVisitor(), new PushDownVariantsVisitor(), new GroupVisitor(), new DetectAmbiguousVisitor(), new NarrowMasksVisitor(), new RemoveUnreachablePatternsVisitor(), new DetectUnreachableFormatsVisitor()};
        if (this.settings.containsKey((Object)Setting.DEBUG)) {
            System.out.println("Debug mode is on. Tree dump:\n");
        }
        for (Visitor visitor : transforms) {
            specification.accept(visitor);
            if (!this.settings.containsKey((Object)Setting.DEBUG)) continue;
            specification.dump(DEBUG_STREAM);
        }
    }
}

