/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.StringWriter;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.generation.GenerateFieldsVisitor;
import net.emustudio.edigen.generation.GenerateMaxInstructionBytes;
import net.emustudio.edigen.generation.GenerateMethodsVisitor;
import net.emustudio.edigen.generation.Generator;
import net.emustudio.edigen.misc.Template;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Rule;

public class DecoderGenerator
extends Generator {
    private final Decoder decoder;

    public DecoderGenerator(Decoder decoder, String name) {
        super("/Decoder.edt", name);
        this.decoder = decoder;
    }

    @Override
    protected void fillTemplate(Template template) throws SemanticException {
        super.fillTemplate(template);
        template.setVariable("decoder_package", this.getPackageName());
        template.setVariable("decoder_class", this.getClassName());
        Rule rootRule = this.decoder.getRootRule();
        if (rootRule.hasOnlyOneName()) {
            template.setVariable("root_rule", rootRule.getMethodName() + "(0)");
        } else {
            template.setVariable("root_rule", rootRule.getMethodName() + "(0, " + rootRule.getFieldName() + ")");
        }
        StringWriter fields = new StringWriter();
        this.decoder.accept(new GenerateFieldsVisitor(fields));
        template.setVariable("decoder_fields", ((Object)fields).toString());
        StringWriter methods = new StringWriter();
        this.decoder.accept(new GenerateMethodsVisitor(methods));
        template.setVariable("decoder_methods", ((Object)methods).toString());
        StringWriter maxInstructionBytes = new StringWriter();
        this.decoder.accept(new GenerateMaxInstructionBytes(maxInstructionBytes));
        template.setVariable("max_instruction_bytes", ((Object)maxInstructionBytes).toString());
    }
}

