/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.StringWriter;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.generation.GenerateFormatsVisitor;
import net.emustudio.edigen.generation.GenerateParametersVisitor;
import net.emustudio.edigen.generation.Generator;
import net.emustudio.edigen.misc.Template;
import net.emustudio.edigen.nodes.Disassembler;

public class DisassemblerGenerator
extends Generator {
    private final Disassembler disassembler;
    private final String decoderName;

    public DisassemblerGenerator(Disassembler disassembler, String disassemblerName, String decoderName) {
        super("/Disassembler.edt", disassemblerName);
        this.disassembler = disassembler;
        this.decoderName = decoderName;
    }

    @Override
    protected void fillTemplate(Template template) throws SemanticException {
        super.fillTemplate(template);
        template.setVariable("disasm_package", this.getPackageName());
        template.setVariable("disasm_class", this.getClassName());
        template.setVariable("decoder_name", this.decoderName);
        StringWriter formats = new StringWriter();
        this.disassembler.accept(new GenerateFormatsVisitor(formats));
        template.setVariable("disasm_formats", ((Object)formats).toString());
        StringWriter values = new StringWriter();
        this.disassembler.accept(new GenerateParametersVisitor(values));
        template.setVariable("disasm_parameters", ((Object)values).toString());
    }
}

