/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.PrettyPrinter;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Variant;

public class GenerateFieldsVisitor
extends Visitor {
    private final PrettyPrinter printer;
    private boolean ruleReturns;
    private final Set<String> fields = new LinkedHashSet<String>();

    public GenerateFieldsVisitor(Writer writer) {
        this.printer = new PrettyPrinter(writer);
    }

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        decoder.acceptChildren(this);
        int ruleNumber = 1;
        for (String field : this.fields) {
            this.printer.writeLine("public static final int " + field + " = " + ruleNumber++ + ";");
        }
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.ruleReturns = false;
        rule.acceptChildren(this);
        if (this.ruleReturns) {
            for (String name : rule.getNames()) {
                this.fields.add(rule.getFieldName(name));
            }
        }
    }

    @Override
    public void visit(Variant variant) {
        if (variant.getFieldName() != null) {
            this.fields.add(variant.getFieldName());
        }
        if (variant.returns()) {
            this.ruleReturns = true;
        }
    }
}

