/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.Writer;
import java.util.Iterator;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.PrettyPrinter;
import net.emustudio.edigen.nodes.Disassembler;
import net.emustudio.edigen.nodes.Format;
import net.emustudio.edigen.nodes.TreeNode;

public class GenerateFormatsVisitor
extends Visitor {
    private final PrettyPrinter printer;
    private String formatString;

    public GenerateFormatsVisitor(Writer writer) {
        this.printer = new PrettyPrinter(writer);
    }

    @Override
    public void visit(Disassembler disassembler) throws SemanticException {
        Iterator<TreeNode> formats = disassembler.getChildren().iterator();
        while (formats.hasNext()) {
            formats.next().accept(this);
            String separator = formats.hasNext() ? ", " : "";
            this.printer.writeLine(this.formatString + separator);
        }
    }

    @Override
    public void visit(Format format) {
        this.formatString = "\"" + format.getFormatString() + "\"";
    }
}

