/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.Writer;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.PrettyPrinter;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Mask;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Subrule;

public class GenerateMaxInstructionBytes
extends Visitor {
    private final PrettyPrinter printer;
    private int maxBitSize;
    private int lastStart;
    private int ruleLevel;

    public GenerateMaxInstructionBytes(Writer output) {
        this.printer = new PrettyPrinter(output);
    }

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        decoder.acceptChildren(this);
        int maxBytes = (int)Math.max(1.0, Math.ceil((double)this.maxBitSize / 8.0));
        this.printer.write(Integer.toString(maxBytes));
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        ++this.ruleLevel;
        if (this.ruleLevel == 1) {
            this.lastStart = 0;
        }
        rule.acceptChildren(this);
    }

    @Override
    public void visit(Mask mask) throws SemanticException {
        int maskLength = mask.getBits().getLength();
        this.maxBitSize = Math.max(this.maxBitSize, this.lastStart + maskLength);
        mask.acceptChildren(this);
    }

    @Override
    public void visit(Subrule subrule) throws SemanticException {
        this.lastStart += subrule.getStart().intValue();
        subrule.getRule().accept(this);
        this.lastStart -= subrule.getStart().intValue();
    }
}

